/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.socket.clientrequest;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import voldemort.VoldemortException;
import voldemort.client.protocol.RequestFormatType;
import voldemort.store.socket.clientrequest.AbstractClientRequest;
import voldemort.utils.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolNegotiatorClientRequest
extends AbstractClientRequest<String> {
    private final RequestFormatType requestFormatType;

    public ProtocolNegotiatorClientRequest(RequestFormatType requestFormatType) {
        this.requestFormatType = requestFormatType;
    }

    @Override
    public boolean isCompleteResponse(ByteBuffer buffer) {
        return buffer.remaining() == 2;
    }

    @Override
    protected void formatRequestInternal(DataOutputStream outputStream) throws IOException {
        outputStream.write(ByteUtils.getBytes(this.requestFormatType.getCode(), "UTF-8"));
    }

    @Override
    protected String parseResponseInternal(DataInputStream inputStream) throws IOException {
        byte[] responseBytes = new byte[2];
        inputStream.readFully(responseBytes);
        String result = ByteUtils.getString(responseBytes, "UTF-8");
        if (result.equals("ok")) {
            return result;
        }
        if (result.equals("no")) {
            throw new VoldemortException(this.requestFormatType.getDisplayName() + " is not an acceptable protcol for the server.");
        }
        throw new VoldemortException("Unknown server response: " + result);
    }
}

