/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import voldemort.utils.DynamicThrottleLimit;
import voldemort.utils.EventThrottler;
import voldemort.utils.Time;

public class DynamicEventThrottler
extends EventThrottler {
    private long dynamicRatePerSecond = 0L;
    private DynamicThrottleLimit dynThrottleLimit;

    public DynamicEventThrottler(long ratesPerSecond) {
        super(ratesPerSecond);
        this.dynamicRatePerSecond = ratesPerSecond;
        this.dynThrottleLimit = null;
    }

    public DynamicEventThrottler(DynamicThrottleLimit dynLimit) {
        super(dynLimit.getRate());
        this.dynThrottleLimit = dynLimit;
    }

    public DynamicEventThrottler(Time time, long ratePerSecond, long intervalMs) {
        super(time, ratePerSecond, intervalMs);
    }

    public synchronized void updateRate(long l) {
        this.dynamicRatePerSecond = l;
    }

    public long getRate() {
        if (this.dynThrottleLimit != null) {
            return this.dynThrottleLimit.getRate();
        }
        return this.dynamicRatePerSecond;
    }
}

