/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import voldemort.VoldemortException;
import voldemort.client.StoreClient;
import voldemort.client.UpdateAction;
import voldemort.cluster.Node;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyStoreClient<K, V>
implements StoreClient<K, V> {
    private final Callable<StoreClient<K, V>> storeClientThunk;
    private StoreClient<K, V> storeClient;

    public LazyStoreClient(Callable<StoreClient<K, V>> storeClientThunk) {
        this.storeClientThunk = storeClientThunk;
    }

    public synchronized StoreClient<K, V> getStoreClient() {
        if (this.storeClient == null) {
            this.storeClient = this.initStoreClient();
        }
        return this.storeClient;
    }

    protected StoreClient<K, V> initStoreClient() {
        try {
            return this.storeClientThunk.call();
        }
        catch (VoldemortException ve) {
            throw ve;
        }
        catch (Exception e) {
            throw new VoldemortException("Unexpected exception during initialization", e);
        }
    }

    @Override
    public V getValue(K key) {
        return this.getStoreClient().getValue(key);
    }

    @Override
    public V getValue(K key, V defaultValue) {
        return this.getStoreClient().getValue(key, defaultValue);
    }

    @Override
    public Versioned<V> get(K key) {
        return this.getStoreClient().get(key);
    }

    @Override
    public Versioned<V> get(K key, Object transforms) {
        return this.getStoreClient().get(key, transforms);
    }

    @Override
    public Map<K, Versioned<V>> getAll(Iterable<K> keys) {
        return this.getStoreClient().getAll(keys);
    }

    @Override
    public Map<K, Versioned<V>> getAll(Iterable<K> keys, Map<K, Object> transforms) {
        return this.getStoreClient().getAll(keys, transforms);
    }

    @Override
    public Versioned<V> get(K key, Versioned<V> defaultValue) {
        return this.getStoreClient().get(key, defaultValue);
    }

    @Override
    public Version put(K key, V value) {
        return this.getStoreClient().put(key, value);
    }

    @Override
    public Version put(K key, V value, Object transforms) {
        return this.getStoreClient().put(key, value, transforms);
    }

    @Override
    public Version put(K key, Versioned<V> versioned) throws ObsoleteVersionException {
        return this.getStoreClient().put(key, versioned);
    }

    @Override
    public boolean putIfNotObsolete(K key, Versioned<V> versioned) {
        return this.getStoreClient().putIfNotObsolete(key, versioned);
    }

    @Override
    public boolean applyUpdate(UpdateAction<K, V> action) {
        return this.getStoreClient().applyUpdate(action);
    }

    @Override
    public boolean applyUpdate(UpdateAction<K, V> action, int maxTries) {
        return this.getStoreClient().applyUpdate(action, maxTries);
    }

    @Override
    public boolean delete(K key) {
        return this.getStoreClient().delete(key);
    }

    @Override
    public boolean delete(K key, Version version) {
        return this.getStoreClient().delete(key, version);
    }

    @Override
    public List<Node> getResponsibleNodes(K key) {
        return this.getStoreClient().getResponsibleNodes(key);
    }
}

