/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonWriter {
    private final Writer writer;

    public JsonWriter(Writer writer) {
        this.writer = writer;
    }

    public void write(Object o) {
        try {
            if (null == o) {
                this.writer.write("null");
            } else if (o instanceof Map) {
                this.writeMap((Map)o);
            } else if (o instanceof List) {
                this.writeList((List)o);
            } else if (o instanceof Date) {
                this.writeDate((Date)o);
            } else if (o instanceof String) {
                this.writer.write(34);
                this.writer.write((String)o);
                this.writer.write(34);
            } else {
                this.writer.write(o.toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("JsonWriter failed to write Object(" + o + ")  as String", e);
        }
    }

    public void writeMap(Map<String, Object> values) throws IOException {
        this.writer.write(123);
        Set<Map.Entry<String, Object>> entrySet = values.entrySet();
        int index = 0;
        for (Map.Entry<String, Object> entry : entrySet) {
            this.writer.write(34);
            this.writer.write(entry.getKey());
            this.writer.write(34);
            this.writer.write(58);
            this.write(entry.getValue());
            if (++index >= entrySet.size()) continue;
            this.writer.write(", ");
        }
        this.writer.write(125);
    }

    public void writeList(List<Object> list) throws IOException {
        this.writer.write(91);
        int index = 0;
        for (Object entry : list) {
            this.write(entry);
            if (++index >= list.size()) continue;
            this.writer.write(", ");
        }
        this.writer.write(93);
    }

    public void writeDate(Date date) throws IOException {
        this.writer.write("" + date.getTime());
    }
}

