/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.scheduler;

import java.util.List;
import org.apache.log4j.Logger;
import voldemort.cluster.Node;
import voldemort.routing.RoutingStrategy;
import voldemort.server.StoreRepository;
import voldemort.store.StorageEngine;
import voldemort.store.Store;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.versioning.Versioned;

public class RebalancingJob
implements Runnable {
    private static Logger logger = Logger.getLogger(RebalancingJob.class);
    private final int localNodeId;
    private final RoutingStrategy router;
    private final StoreRepository storeRepository;

    public RebalancingJob(int localNodeId, RoutingStrategy router, StoreRepository storeRepository) {
        this.localNodeId = localNodeId;
        this.storeRepository = storeRepository;
        this.router = router;
    }

    public void run() {
        logger.info((Object)"Rebalancing all keys...");
        int totalRebalanced = 0;
        long start = System.currentTimeMillis();
        for (StorageEngine<ByteArray, byte[], byte[]> engine : this.storeRepository.getAllStorageEngines()) {
            logger.info((Object)("Rebalancing " + engine.getName()));
            Store<ByteArray, byte[], byte[]> remote = this.storeRepository.getRoutedStore(engine.getName());
            ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> iterator = engine.entries();
            int rebalanced = 0;
            long currStart = System.currentTimeMillis();
            while (iterator.hasNext()) {
                Pair keyAndVal = (Pair)iterator.next();
                if (!this.needsRebalancing((ByteArray)keyAndVal.getFirst())) continue;
                remote.put((ByteArray)keyAndVal.getFirst(), (Versioned)keyAndVal.getSecond(), (byte[])null);
                engine.delete((ByteArray)keyAndVal.getFirst(), ((Versioned)keyAndVal.getSecond()).getVersion());
                ++rebalanced;
            }
            totalRebalanced += rebalanced;
            long ellapsedSeconds = (System.currentTimeMillis() - currStart) / 1000L;
            logger.info((Object)("Rebalancing of store " + engine.getName() + " completed in " + ellapsedSeconds + " seconds."));
            logger.info((Object)(rebalanced + " keys rebalanced."));
        }
        long ellapsedSeconds = (System.currentTimeMillis() - start) / 1000L;
        logger.info((Object)("Rebalancing complete for all stores in " + ellapsedSeconds + " seconds."));
        logger.info((Object)(totalRebalanced + " keys rebalanced in total."));
    }

    private boolean needsRebalancing(ByteArray key) {
        List<Node> responsible = this.router.routeRequest(key.get());
        for (Node n : responsible) {
            if (n.getId() != this.localNodeId) continue;
            return false;
        }
        return true;
    }
}

