/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.store.readonly.ReadOnlyStorageFormat;
import voldemort.utils.ByteUtils;
import voldemort.utils.Pair;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyUtils {
    public static final int POSITION_SIZE = 4;
    private static Logger logger = Logger.getLogger(ReadOnlyUtils.class);

    public static int chunk(byte[] key, int numChunks) {
        return Math.max(0, Math.abs(ByteUtils.readInt(key, 0))) % numChunks;
    }

    public static byte[] readKey(ByteBuffer index, int indexByteOffset, byte[] foundKey) {
        index.position(indexByteOffset);
        index.get(foundKey);
        return foundKey;
    }

    public static boolean isFormatCorrect(String fileName, ReadOnlyStorageFormat format) {
        switch (format) {
            case READONLY_V0: 
            case READONLY_V1: {
                return fileName.matches("^[\\d]+_[\\d]+\\.(data|index)");
            }
            case READONLY_V2: {
                return fileName.matches("^[\\d]+_[\\d]+_[\\d]+\\.(data|index)");
            }
        }
        throw new VoldemortException("Format type not supported");
    }

    public static Pair<Integer, Integer> getPartitionReplicaTuple(String fileName) {
        if (!ReadOnlyUtils.isFormatCorrect(fileName, ReadOnlyStorageFormat.READONLY_V2)) {
            throw new VoldemortException("Filename " + fileName + " does not comply with the format for storage format " + (Object)((Object)ReadOnlyStorageFormat.READONLY_V2));
        }
        int firstUnderScore = fileName.indexOf(95);
        int secondUnderScore = fileName.indexOf(95, firstUnderScore + 1);
        return Pair.create(Integer.parseInt(fileName.substring(0, firstUnderScore)), Integer.parseInt(fileName.substring(firstUnderScore + 1, secondUnderScore)));
    }

    public static int getChunkId(String fileName) {
        Pattern pattern = Pattern.compile("_[\\d]+\\.");
        Matcher matcher = pattern.matcher(fileName);
        if (matcher.find()) {
            return new Integer(fileName.substring(matcher.start() + 1, matcher.end() - 1));
        }
        throw new VoldemortException("Could not extract out chunk id from " + fileName);
    }

    public static File getCurrentVersion(File storeDirectory) {
        File latestDir = ReadOnlyUtils.getLatestDir(storeDirectory);
        if (latestDir != null) {
            return latestDir;
        }
        File[] versionDirs = ReadOnlyUtils.getVersionDirs(storeDirectory);
        if (versionDirs == null || versionDirs.length == 0) {
            return null;
        }
        return ReadOnlyUtils.findKthVersionedDir(versionDirs, versionDirs.length - 1, versionDirs.length - 1)[0];
    }

    public static File getLatestDir(File parentDir) {
        File latestSymLink = new File(parentDir, "latest");
        if (latestSymLink.exists() && Utils.isSymLink(latestSymLink)) {
            File canonicalLatestVersion = null;
            try {
                canonicalLatestVersion = latestSymLink.getCanonicalFile();
            }
            catch (IOException e) {
                return null;
            }
            if (canonicalLatestVersion != null && ReadOnlyUtils.checkVersionDirName(canonicalLatestVersion)) {
                return canonicalLatestVersion;
            }
        }
        return null;
    }

    public static boolean checkVersionDirName(File versionDir) {
        return versionDir.isDirectory() && versionDir.getName().contains("version-") && !versionDir.getName().endsWith(".bak");
    }

    public static long getVersionId(File versionDir) {
        return ReadOnlyUtils.getVersionId(versionDir.getName());
    }

    private static long getVersionId(String versionDir) {
        try {
            return Long.parseLong(versionDir.replace("version-", ""));
        }
        catch (NumberFormatException e) {
            logger.trace((Object)("Cannot parse version directory to obtain id " + versionDir));
            return -1L;
        }
    }

    public static File[] getVersionDirs(File rootDir) {
        return ReadOnlyUtils.getVersionDirs(rootDir, 0L, Long.MAX_VALUE);
    }

    public static File[] getVersionDirs(File rootDir, final long minId, final long maxId) {
        return rootDir.listFiles(new FileFilter(){

            public boolean accept(File pathName) {
                long versionId;
                return ReadOnlyUtils.checkVersionDirName(pathName) && (versionId = ReadOnlyUtils.getVersionId(pathName)) != -1L && versionId <= maxId && versionId >= minId;
            }
        });
    }

    public static File[] findKthVersionedDir(File[] versionDirs, int start, int end) {
        if (start < 0 || end >= versionDirs.length) {
            logger.error((Object)("Incorrect version number requested (" + start + "," + end + "). Should be between (0," + (versionDirs.length - 1) + ")"));
            return null;
        }
        Collections.sort(Arrays.asList(versionDirs), new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                long fileId2;
                long fileId1 = ReadOnlyUtils.getVersionId(file1);
                if (fileId1 == (fileId2 = ReadOnlyUtils.getVersionId(file2))) {
                    return 0;
                }
                if (fileId1 == -1L) {
                    return 1;
                }
                if (fileId2 == -1L) {
                    return -1;
                }
                if (fileId1 < fileId2) {
                    return -1;
                }
                return 1;
            }
        });
        File[] returnedFiles = new File[end - start + 1];
        int index = start;
        int index2 = 0;
        while (index <= end) {
            returnedFiles[index2] = versionDirs[index];
            ++index;
            ++index2;
        }
        return returnedFiles;
    }
}

