/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.store.InsufficientOperationalNodesException;
import voldemort.store.routed.action.Action;

public class Pipeline {
    private final Operation operation;
    private final long timeout;
    private final TimeUnit unit;
    private final BlockingQueue<Event> eventQueue;
    private final Map<Event, Action> eventActions;
    private final Logger logger = Logger.getLogger(this.getClass());
    private volatile boolean enableHintedHandoff = false;
    private volatile boolean finished = false;

    public Pipeline(Operation operation, long timeout, TimeUnit unit) {
        this.operation = operation;
        this.timeout = timeout;
        this.unit = unit;
        this.eventQueue = new LinkedBlockingQueue<Event>();
        this.eventActions = new ConcurrentHashMap<Event, Action>();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void addEventAction(Event event, Action action) {
        this.eventActions.put(event, action);
    }

    public void abort() {
        if (this.isHintedHandoffEnabled()) {
            this.addEvent(Event.ABORTED);
        } else {
            this.addEvent(Event.ERROR);
        }
    }

    public void addEvent(Event event) {
        if (event == null) {
            throw new IllegalStateException("event must be non-null");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Adding event " + (Object)((Object)event)));
        }
        this.eventQueue.add(event);
    }

    public boolean isHintedHandoffEnabled() {
        return this.enableHintedHandoff;
    }

    public void setEnableHintedHandoff(boolean enableHintedHandoff) {
        this.enableHintedHandoff = enableHintedHandoff;
    }

    public boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            while (true) {
                Event event = null;
                try {
                    event = this.eventQueue.poll(this.timeout, this.unit);
                }
                catch (InterruptedException e) {
                    throw new InsufficientOperationalNodesException(this.operation.getSimpleName() + " operation interrupted!", e);
                }
                if (event == null) {
                    throw new VoldemortException(this.operation.getSimpleName() + " returned a null event");
                }
                if (event.equals((Object)Event.ERROR)) {
                    if (!this.logger.isTraceEnabled()) break;
                    this.logger.trace((Object)(this.operation.getSimpleName() + " request, events complete due to error"));
                    break;
                }
                if (event.equals((Object)Event.COMPLETED)) {
                    if (!this.logger.isTraceEnabled()) break;
                    this.logger.trace((Object)(this.operation.getSimpleName() + " request, events complete"));
                    break;
                }
                Action action = this.eventActions.get((Object)event);
                if (action == null) {
                    throw new IllegalStateException("action was null for event " + (Object)((Object)event));
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)(this.operation.getSimpleName() + " request, action " + action.getClass().getSimpleName() + " to handle " + (Object)((Object)event) + " event"));
                }
                action.execute(this);
            }
            Object var4_4 = null;
            this.finished = true;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.finished = true;
            throw throwable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        GET,
        GET_ALL,
        GET_VERSIONS,
        PUT,
        DELETE;


        public String getSimpleName() {
            return this.toString().toLowerCase().replace("_", " ");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Event {
        STARTED,
        CONFIGURED,
        COMPLETED,
        INSUFFICIENT_SUCCESSES,
        INSUFFICIENT_ZONES,
        RESPONSES_RECEIVED,
        ERROR,
        MASTER_DETERMINED,
        ABORTED,
        HANDOFF_FINISHED;

    }
}

