/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdUtils {
    public static Set<String> missing(OptionSet options, String ... required) {
        HashSet<String> missing = new HashSet<String>();
        for (String arg : required) {
            if (options.has(arg)) continue;
            missing.add(arg);
        }
        return missing;
    }

    public static Set<OptionSpec<?>> missing(OptionSet options, OptionSpec<?> ... required) {
        HashSet missing = new HashSet();
        for (OptionSpec<?> opt : required) {
            if (options.has(opt)) continue;
            missing.add(opt);
        }
        return missing;
    }

    public static <T> T valueOf(OptionSet options, String opt, T defaultValue) {
        if (options.has(opt)) {
            return (T)options.valueOf(opt);
        }
        return defaultValue;
    }

    public static <T> T valueOf(OptionSet options, OptionSpec<T> opt, T defaultValue) {
        if (options.has(opt)) {
            return (T)options.valueOf(opt);
        }
        return defaultValue;
    }

    public static void croakIfMissing(OptionParser parser, OptionSet options, String ... required) {
        Set<String> missing = CmdUtils.missing(options, required);
        if (missing.size() > 0) {
            System.err.println("Missing required arguments: " + Joiner.on((String)", ").join(missing));
            try {
                parser.printHelpOn((OutputStream)System.err);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.exit(1);
        }
    }
}

