/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.jexl2.parser.JexlNode;
import org.apache.commons.jexl2.parser.Parser;
import org.apache.commons.jexl2.parser.ParserVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTNumberLiteral
extends JexlNode
implements JexlNode.Literal<Number> {
    Number literal = null;
    Class<?> clazz = null;

    public ASTNumberLiteral(int id) {
        super(id);
    }

    public ASTNumberLiteral(Parser p, int id) {
        super(p, id);
    }

    @Override
    public Number getLiteral() {
        return this.literal;
    }

    @Override
    protected boolean isConstant(boolean literal) {
        return true;
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Class<?> getLiteralClass() {
        return this.clazz;
    }

    public boolean isInteger() {
        return Integer.class.equals(this.clazz);
    }

    public void setNatural(String s) {
        Number result;
        Class rclass;
        int base;
        if (s.charAt(0) == '0') {
            if (s.length() > 1 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                base = 16;
                s = s.substring(2);
            } else {
                base = 8;
            }
        } else {
            base = 10;
        }
        int last = s.length() - 1;
        switch (s.charAt(last)) {
            case 'L': 
            case 'l': {
                rclass = Long.class;
                result = Long.valueOf(s.substring(0, last), base);
                break;
            }
            case 'H': 
            case 'h': {
                rclass = BigInteger.class;
                result = new BigInteger(s.substring(0, last), base);
                break;
            }
            default: {
                rclass = Integer.class;
                try {
                    result = Integer.valueOf(s, base);
                    break;
                }
                catch (NumberFormatException take2) {
                    try {
                        result = Long.valueOf(s, base);
                        break;
                    }
                    catch (NumberFormatException take3) {
                        result = new BigInteger(s, base);
                    }
                }
            }
        }
        this.literal = result;
        this.clazz = rclass;
    }

    public void setReal(String s) {
        Class rclass;
        Number result;
        int last = s.length() - 1;
        switch (s.charAt(last)) {
            case 'B': 
            case 'b': {
                result = new BigDecimal(s.substring(0, last));
                rclass = BigDecimal.class;
                break;
            }
            case 'D': 
            case 'd': {
                rclass = Double.class;
                result = Double.valueOf(s);
                break;
            }
            default: {
                rclass = Float.class;
                try {
                    result = Float.valueOf(s);
                    break;
                }
                catch (NumberFormatException take2) {
                    try {
                        result = Double.valueOf(s);
                        break;
                    }
                    catch (NumberFormatException take3) {
                        result = new BigDecimal(s);
                    }
                }
            }
        }
        this.literal = result;
        this.clazz = rclass;
    }
}

