/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger.builtin;

import azkaban.alert.Alerter;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.sla.SlaOption;
import azkaban.trigger.TriggerAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class SlaAlertAction
implements TriggerAction {
    public static final String type = "AlertAction";
    private static final Logger logger = Logger.getLogger(SlaAlertAction.class);
    private String actionId;
    private SlaOption slaOption;
    private int execId;
    private static Map<String, Alerter> alerters;
    private static ExecutorManagerAdapter executorManager;

    public SlaAlertAction(String id, SlaOption slaOption, int execId) {
        this.actionId = id;
        this.slaOption = slaOption;
        this.execId = execId;
    }

    public static void setAlerters(Map<String, Alerter> alts) {
        alerters = alts;
    }

    public static void setExecutorManager(ExecutorManagerAdapter em) {
        executorManager = em;
    }

    public String getId() {
        return this.actionId;
    }

    public String getType() {
        return "AlertAction";
    }

    public static SlaAlertAction createFromJson(Object obj) throws Exception {
        return SlaAlertAction.createFromJson((HashMap)((HashMap)obj));
    }

    public static SlaAlertAction createFromJson(HashMap<String, Object> obj) throws Exception {
        HashMap<String, Object> jsonObj = obj;
        if (!jsonObj.get("type").equals("AlertAction")) {
            throw new Exception("Cannot create action of AlertAction from " + jsonObj.get("type"));
        }
        String actionId = (String)jsonObj.get("actionId");
        SlaOption slaOption = SlaOption.fromObject(jsonObj.get("slaOption"));
        int execId = Integer.valueOf((String)jsonObj.get("execId"));
        return new SlaAlertAction(actionId, slaOption, execId);
    }

    public TriggerAction fromJson(Object obj) throws Exception {
        return SlaAlertAction.createFromJson((Object)obj);
    }

    public Object toJson() {
        HashMap<String, Object> jsonObj = new HashMap<String, Object>();
        jsonObj.put("actionId", this.actionId);
        jsonObj.put("type", "AlertAction");
        jsonObj.put("slaOption", this.slaOption.toObject());
        jsonObj.put("execId", String.valueOf(this.execId));
        return jsonObj;
    }

    public void doAction() throws Exception {
        logger.info((Object)"Alerting on sla failure.");
        Map alert = this.slaOption.getInfo();
        if (alert.containsKey("SlaAlertType")) {
            String alertType = (String)alert.get("SlaAlertType");
            Alerter alerter = (Alerter)alerters.get(alertType);
            if (alerter != null) {
                try {
                    ExecutableFlow flow = executorManager.getExecutableFlow(this.execId);
                    alerter.alertOnSla(this.slaOption, SlaOption.createSlaMessage((SlaOption)this.slaOption, (ExecutableFlow)flow));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error((Object)("Failed to alert by " + alertType));
                }
            } else {
                logger.error((Object)("Alerter type " + alertType + " doesn't exist. Failed to alert."));
            }
        }
    }

    public void setContext(Map<String, Object> context) {
    }

    public String getDescription() {
        return "AlertAction for " + this.execId + " with " + this.slaOption.toString();
    }
}

