/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization;

import java.util.HashMap;
import java.util.Map;
import voldemort.serialization.IdentitySerializer;
import voldemort.serialization.ObjectSerializer;
import voldemort.serialization.Serializer;
import voldemort.serialization.SerializerDefinition;
import voldemort.serialization.SerializerFactory;
import voldemort.serialization.StringSerializer;
import voldemort.serialization.avro.AvroGenericSerializer;
import voldemort.serialization.avro.AvroReflectiveSerializer;
import voldemort.serialization.avro.AvroSpecificSerializer;
import voldemort.serialization.json.JsonTypeDefinition;
import voldemort.serialization.json.JsonTypeSerializer;
import voldemort.serialization.protobuf.ProtoBufSerializer;
import voldemort.serialization.thrift.ThriftSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSerializerFactory
implements SerializerFactory {
    private static final String JAVA_SERIALIZER_TYPE_NAME = "java-serialization";
    private static final String STRING_SERIALIZER_TYPE_NAME = "string";
    private static final String IDENTITY_SERIALIZER_TYPE_NAME = "identity";
    private static final String JSON_SERIALIZER_TYPE_NAME = "json";
    private static final String PROTO_BUF_TYPE_NAME = "protobuf";
    private static final String THRIFT_TYPE_NAME = "thrift";
    private static final String AVRO_GENERIC_TYPE_NAME = "avro-generic";
    private static final String AVRO_SPECIFIC_TYPE_NAME = "avro-specific";
    private static final String AVRO_REFLECTIVE_TYPE_NAME = "avro-reflective";

    @Override
    public Serializer<?> getSerializer(SerializerDefinition serializerDef) {
        String name = serializerDef.getName();
        if (name.equals(JAVA_SERIALIZER_TYPE_NAME)) {
            return new ObjectSerializer();
        }
        if (name.equals(STRING_SERIALIZER_TYPE_NAME)) {
            return new StringSerializer(serializerDef.hasSchemaInfo() ? serializerDef.getCurrentSchemaInfo() : "UTF8");
        }
        if (name.equals(IDENTITY_SERIALIZER_TYPE_NAME)) {
            return new IdentitySerializer();
        }
        if (name.equals(JSON_SERIALIZER_TYPE_NAME)) {
            if (serializerDef.hasVersion()) {
                HashMap<Integer, JsonTypeDefinition> versions = new HashMap<Integer, JsonTypeDefinition>();
                for (Map.Entry<Integer, String> entry : serializerDef.getAllSchemaInfoVersions().entrySet()) {
                    versions.put(entry.getKey(), JsonTypeDefinition.fromJson(entry.getValue()));
                }
                return new JsonTypeSerializer(versions);
            }
            return new JsonTypeSerializer(JsonTypeDefinition.fromJson(serializerDef.getCurrentSchemaInfo()));
        }
        if (name.equals(PROTO_BUF_TYPE_NAME)) {
            return new ProtoBufSerializer(serializerDef.getCurrentSchemaInfo());
        }
        if (name.equals(THRIFT_TYPE_NAME)) {
            return new ThriftSerializer(serializerDef.getCurrentSchemaInfo());
        }
        if (name.equals(AVRO_GENERIC_TYPE_NAME)) {
            return new AvroGenericSerializer(serializerDef.getCurrentSchemaInfo());
        }
        if (name.equals(AVRO_SPECIFIC_TYPE_NAME)) {
            return new AvroSpecificSerializer(serializerDef.getCurrentSchemaInfo());
        }
        if (name.equals(AVRO_REFLECTIVE_TYPE_NAME)) {
            return new AvroReflectiveSerializer(serializerDef.getCurrentSchemaInfo());
        }
        throw new IllegalArgumentException("No known serializer type: " + serializerDef.getName());
    }
}

