/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.scheduler;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.server.AbstractService;
import voldemort.server.ServiceType;
import voldemort.server.VoldemortService;
import voldemort.utils.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JmxManaged(description="A service that runs scheduled jobs.")
public class SchedulerService
extends AbstractService {
    private static final Logger logger = Logger.getLogger(VoldemortService.class);
    private boolean mayInterrupt;
    private final ScheduledThreadPoolExecutor scheduler;
    private final Time time;
    private final ConcurrentHashMap<String, ScheduledFuture> scheduledJobResults;
    private final ConcurrentHashMap<String, ScheduledRunnable> allJobs;

    public SchedulerService(int schedulerThreads, Time time) {
        this(schedulerThreads, time, true);
    }

    public SchedulerService(int schedulerThreads, Time time, boolean mayInterrupt) {
        super(ServiceType.SCHEDULER);
        this.time = time;
        this.scheduler = new SchedulerThreadPool(schedulerThreads);
        this.scheduledJobResults = new ConcurrentHashMap();
        this.allJobs = new ConcurrentHashMap();
        this.mayInterrupt = mayInterrupt;
    }

    @Override
    public void startInner() {
    }

    @Override
    public void stopInner() {
        this.scheduler.shutdownNow();
    }

    @JmxOperation(description="Disable a particular scheduled job", impact=1)
    public void disable(String id) {
        ScheduledFuture future;
        boolean cancelled;
        if (this.allJobs.containsKey(id) && this.scheduledJobResults.containsKey(id) && (cancelled = (future = this.scheduledJobResults.get(id)).cancel(false))) {
            logger.info((Object)("Removed '" + id + "' from list of scheduled jobs"));
            this.scheduledJobResults.remove(id);
        }
    }

    @JmxOperation(description="Terminate a particular scheduled job", impact=1)
    public void terminate(String id) {
        ScheduledFuture future;
        boolean cancelled;
        if (this.allJobs.containsKey(id) && this.scheduledJobResults.containsKey(id) && (cancelled = (future = this.scheduledJobResults.get(id)).cancel(this.mayInterrupt))) {
            logger.info((Object)("Removed '" + id + "' from list of scheduled jobs"));
            this.scheduledJobResults.remove(id);
        }
    }

    @JmxOperation(description="Enable a particular scheduled job", impact=1)
    public void enable(String id) {
        if (this.allJobs.containsKey(id) && !this.scheduledJobResults.containsKey(id)) {
            ScheduledRunnable scheduledRunnable = this.allJobs.get(id);
            logger.info((Object)("Adding '" + id + "' to list of scheduled jobs"));
            if (scheduledRunnable.getIntervalMs() > 0L) {
                this.schedule(id, scheduledRunnable.getRunnable(), scheduledRunnable.getDelayDate(), scheduledRunnable.getIntervalMs());
            } else {
                this.schedule(id, scheduledRunnable.getRunnable(), scheduledRunnable.getDelayDate());
            }
        }
    }

    @JmxGetter(name="getScheduledJobs", description="Returns names of jobs in the scheduler")
    public List<String> getScheduledJobs() {
        return Lists.newArrayList((Iterable)this.scheduledJobResults.keySet());
    }

    public void scheduleNow(Runnable runnable) {
        this.scheduler.execute(runnable);
    }

    public void schedule(String id, Runnable runnable, Date timeToRun) {
        ScheduledFuture<?> future = this.scheduler.schedule(runnable, this.delayMs(timeToRun), TimeUnit.MILLISECONDS);
        if (!this.allJobs.containsKey(id)) {
            this.allJobs.put(id, new ScheduledRunnable(runnable, timeToRun));
        }
        this.scheduledJobResults.put(id, future);
    }

    public void schedule(String id, Runnable runnable, Date nextRun, long periodMs) {
        ScheduledFuture<?> future = this.scheduler.scheduleWithFixedDelay(runnable, this.delayMs(nextRun), periodMs, TimeUnit.MILLISECONDS);
        if (!this.allJobs.containsKey(id)) {
            this.allJobs.put(id, new ScheduledRunnable(runnable, nextRun, periodMs));
        }
        this.scheduledJobResults.put(id, future);
    }

    private long delayMs(Date runDate) {
        return Math.max(0L, runDate.getTime() - this.time.getMilliseconds());
    }

    private static class SchedulerThreadPool
    extends ScheduledThreadPoolExecutor {
        public SchedulerThreadPool(int numThreads) {
            super(numThreads, new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    thread.setName(r.getClass().getName());
                    return thread;
                }
            });
        }
    }

    private class ScheduledRunnable {
        private Runnable runnable;
        private Date delayDate;
        private long intervalMs;

        ScheduledRunnable(Runnable runnable, Date delayDate, long intervalMs) {
            this.runnable = runnable;
            this.delayDate = delayDate;
            this.intervalMs = intervalMs;
        }

        ScheduledRunnable(Runnable runnable, Date delayDate) {
            this(runnable, delayDate, 0L);
        }

        Runnable getRunnable() {
            return this.runnable;
        }

        Date getDelayDate() {
            return this.delayDate;
        }

        long getIntervalMs() {
            return this.intervalMs;
        }
    }
}

