/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import voldemort.serialization.json.JsonReader;
import voldemort.serialization.json.JsonWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyStorageMetadata {
    public static final String FORMAT = "format";
    public static final String CHECKSUM_TYPE = "checksum-type";
    public static final String CHECKSUM = "checksum";
    private Map<String, Object> properties = new HashMap<String, Object>();

    public ReadOnlyStorageMetadata() {
    }

    public ReadOnlyStorageMetadata(Map<String, Object> prop) {
        this();
        this.properties.putAll(prop);
    }

    public ReadOnlyStorageMetadata(String json) {
        this();
        JsonReader reader = new JsonReader(new StringReader(json));
        this.properties.putAll(reader.readObject());
    }

    public ReadOnlyStorageMetadata(File metadataFile) throws IOException {
        this();
        BufferedReader reader = new BufferedReader(new FileReader(metadataFile.getAbsolutePath()));
        JsonReader jsonReader = new JsonReader(reader);
        this.properties.putAll(jsonReader.readObject());
    }

    public String toJsonString() throws IOException {
        StringWriter stringWriter = new StringWriter();
        new JsonWriter(stringWriter).writeMap(this.properties);
        stringWriter.flush();
        return stringWriter.toString();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public void add(String key, String value) {
        this.properties.put(key, value);
    }

    public void remove(String key) {
        this.properties.remove(key);
    }

    public Object get(String key) {
        return this.properties.get(key);
    }

    public Object get(String key, Object defaultValue) {
        if (this.properties.get(key) == null) {
            return defaultValue;
        }
        return this.properties.get(key);
    }

    public Map<String, Object> getAll() {
        return Maps.newHashMap(this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadOnlyStorageMetadata that = (ReadOnlyStorageMetadata)o;
        Map<String, Object> thisMap = this.getAll();
        Map<String, Object> thatMap = that.getAll();
        if (thisMap == null && thatMap == null) {
            return true;
        }
        if (thisMap == null || thatMap == null) {
            return false;
        }
        for (String key : thisMap.keySet()) {
            Object thisValue = thisMap.get(key);
            Object thatValue = thatMap.get(key);
            if (thisValue == null && thatValue == null) continue;
            if (thisValue == null || thatValue == null) {
                return false;
            }
            if (thisValue.equals(thatValue)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return ((Object)this.properties).hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReadOnlyStorageMetadata( ");
        sb.append("\n");
        for (String key : this.properties.keySet()) {
            sb.append(key + " : " + this.properties.get(key) + ",");
            sb.append("\n");
        }
        sb.append(")");
        return sb.toString();
    }
}

