/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.slop.strategy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.store.slop.strategy.HintedHandoffStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsistentHandoffStrategy
implements HintedHandoffStrategy {
    private final Map<Integer, List<Node>> routeToMap;

    public ConsistentHandoffStrategy(Cluster cluster, int prefListSize, boolean enableZoneRouting, int clientZoneId) {
        int nodesInCluster = cluster.getNumberOfNodes();
        if (prefListSize > nodesInCluster - 1) {
            throw new IllegalArgumentException("Preference list size must be less than number of nodes in the cluster - 1");
        }
        this.routeToMap = Maps.newHashMapWithExpectedSize((int)cluster.getNumberOfNodes());
        for (Node node : cluster.getNodes()) {
            ArrayList prefList = Lists.newArrayListWithCapacity((int)prefListSize);
            int i = node.getId();
            int n = 0;
            while (n < prefListSize) {
                Node peer = cluster.getNodeById(i = (i + 1) % cluster.getNumberOfNodes());
                if (peer.getId() != node.getId()) {
                    int zoneId;
                    if (enableZoneRouting && cluster.getZones().size() > 1 && (clientZoneId == (zoneId = node.getZoneId()) ? peer.getZoneId() != zoneId : peer.getZoneId() == zoneId)) continue;
                    prefList.add(peer);
                    ++n;
                }
                this.routeToMap.put(node.getId(), prefList);
            }
        }
    }

    @Override
    public List<Node> routeHint(Node origin) {
        ArrayList prefList = Lists.newArrayList((Iterable)this.routeToMap.get(origin.getId()));
        Collections.shuffle(prefList);
        return prefList;
    }

    public String toString() {
        return "ConsistentHandoffStrategy(" + this.routeToMap.toString() + ")";
    }
}

