/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.socket.clientrequest;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import voldemort.client.protocol.RequestFormat;
import voldemort.server.RequestRoutingType;
import voldemort.store.socket.clientrequest.AbstractStoreClientRequest;
import voldemort.utils.ByteArray;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutClientRequest
extends AbstractStoreClientRequest<Void> {
    private final ByteArray key;
    private final Versioned<byte[]> versioned;
    private final byte[] transforms;

    public PutClientRequest(String storeName, RequestFormat requestFormat, RequestRoutingType requestRoutingType, ByteArray key, Versioned<byte[]> versioned, byte[] transforms) {
        super(storeName, requestFormat, requestRoutingType);
        this.key = key;
        this.versioned = versioned;
        this.transforms = transforms;
    }

    @Override
    public boolean isCompleteResponse(ByteBuffer buffer) {
        return this.requestFormat.isCompletePutResponse(buffer);
    }

    @Override
    protected void formatRequestInternal(DataOutputStream outputStream) throws IOException {
        this.requestFormat.writePutRequest(outputStream, this.storeName, this.key, this.versioned.getValue(), this.transforms, (VectorClock)this.versioned.getVersion(), this.requestRoutingType);
    }

    @Override
    protected Void parseResponseInternal(DataInputStream inputStream) throws IOException {
        this.requestFormat.readPutResponse(inputStream);
        return null;
    }
}

