/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.stats;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import voldemort.store.stats.RequestCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamStats {
    private static final int MAX_ENTRIES = 64;
    private final Map<Long, Handle> handles = Collections.synchronizedMap(new Cache(64));
    private final AtomicLong handleIdGenerator = new AtomicLong(0L);
    private final ConcurrentMap<Operation, RequestCounter> networkCounter = new ConcurrentHashMap<Operation, RequestCounter>();
    private final ConcurrentMap<Operation, RequestCounter> diskCounter = new ConcurrentHashMap<Operation, RequestCounter>();

    public StreamStats() {
        for (Operation operation : Operation.values()) {
            this.networkCounter.put(operation, new RequestCounter(300000));
            this.diskCounter.put(operation, new RequestCounter(30000));
        }
    }

    public Handle makeHandle(Operation operation, HashMap<Integer, List<Integer>> replicaToPartitionList) {
        Handle handle = new Handle(this.handleIdGenerator.getAndIncrement(), operation, System.currentTimeMillis(), replicaToPartitionList);
        this.handles.put(handle.getId(), handle);
        return handle;
    }

    public void closeHandle(Handle handle) {
        handle.setFinished(true);
    }

    public void clearFinished() {
        for (long handleId : this.getHandleIds()) {
            if (!this.getHandle(handleId).isFinished()) continue;
            this.handles.remove(handleId);
        }
    }

    protected Handle getHandle(long handleId) {
        if (!this.handles.containsKey(handleId)) {
            throw new IllegalArgumentException("No handle with id " + handleId);
        }
        return this.handles.get(handleId);
    }

    public Collection<Long> getHandleIds() {
        return ImmutableList.copyOf(this.handles.keySet());
    }

    public Collection<Handle> getHandles() {
        return ImmutableList.copyOf(this.handles.values());
    }

    public void recordNetworkTime(Handle handle, long timeNs) {
        ((RequestCounter)this.networkCounter.get((Object)handle.getOperation())).addRequest(timeNs);
    }

    public void recordDiskTime(Handle handle, long timeNs) {
        ((RequestCounter)this.diskCounter.get((Object)handle.getOperation())).addRequest(timeNs);
    }

    public RequestCounter getNetworkCounter(Operation operation) {
        return (RequestCounter)this.networkCounter.get((Object)operation);
    }

    public RequestCounter getDiskCounter(Operation operation) {
        return (RequestCounter)this.diskCounter.get((Object)operation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Handle {
        private final long id;
        private final Operation operation;
        private final long startedMs;
        private final HashMap<Integer, List<Integer>> replicaToPartitionList;
        private final AtomicLong entriesScanned;
        private final AtomicLong timeNetworkNs;
        private final AtomicLong timeDiskNs;
        private volatile boolean finished;

        private Handle(long id, Operation operation, long startedMs, HashMap<Integer, List<Integer>> replicaToPartitionList) {
            this.id = id;
            this.operation = operation;
            this.startedMs = startedMs;
            this.replicaToPartitionList = replicaToPartitionList;
            this.entriesScanned = new AtomicLong(0L);
            this.timeNetworkNs = new AtomicLong(0L);
            this.timeDiskNs = new AtomicLong(0L);
            this.finished = false;
        }

        public long getId() {
            return this.id;
        }

        public long getStartedMs() {
            return this.startedMs;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public long getEntriesScanned() {
            return this.entriesScanned.get();
        }

        public long incrementEntriesScanned() {
            return this.entriesScanned.incrementAndGet();
        }

        public void setEntriesScanned(long newVal) {
            this.entriesScanned.set(newVal);
        }

        public long getEntriesPerSecond() {
            long elapsedSecs = System.currentTimeMillis() - this.startedMs;
            if (elapsedSecs == 0L) {
                return 0L;
            }
            return this.getEntriesScanned() / elapsedSecs;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void setFinished(boolean finished) {
            this.finished = finished;
        }

        public HashMap<Integer, List<Integer>> getReplicaToPartitionList() {
            return this.replicaToPartitionList;
        }

        public void recordTimeNetwork(long deltaNs) {
            this.timeNetworkNs.addAndGet(deltaNs);
        }

        public long getTimeNetworkNs() {
            return this.timeNetworkNs.get();
        }

        public void recordTimeDisk(long deltaNs) {
            this.timeDiskNs.addAndGet(deltaNs);
        }

        public long getTimeDiskNs() {
            return this.timeDiskNs.get();
        }

        public double getPercentDisk() {
            long timeDiskMs = this.getTimeDiskNs() / 1000000L;
            return (double)timeDiskMs * 100.0 / (double)(System.currentTimeMillis() - this.startedMs);
        }

        public double getPercentNetwork() {
            long timeNetworkMs = this.getTimeNetworkNs() / 1000000L;
            return (double)timeNetworkMs * 100.0 / (double)(System.currentTimeMillis() - this.startedMs);
        }

        public String toString() {
            return "Handle{id=" + this.id + ", operation=" + (Object)((Object)this.operation) + ", startedMs=" + this.startedMs + ", replicaToPartitionList=" + this.getReplicaToPartitionList() + ", entriesScanned=" + this.getEntriesScanned() + ", finished=" + this.finished + ", entriesPerSecond=" + this.getEntriesPerSecond() + ", timeDiskNs=" + this.getTimeDiskNs() + ", timeNetworkNs=" + this.getTimeNetworkNs() + ", percentDisk=" + this.getPercentDisk() + ", percentNetwork=" + this.getPercentNetwork() + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Cache
    extends LinkedHashMap<Long, Handle> {
        private static final long serialVersionUID = 1L;
        private final int maxEntries;

        public Cache(int maxEntries) {
            this.maxEntries = maxEntries;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, Handle> eldest) {
            return eldest.getValue().isFinished() && this.size() > this.maxEntries;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        FETCH_KEYS,
        FETCH_ENTRIES,
        FETCH_FILE,
        UPDATE,
        SLOP,
        DELETE;

    }
}

