/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.annotations.jmx.JmxParam;
import voldemort.annotations.jmx.JmxSetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxUtils {
    private static final Object LOCK = new Object();
    private static final Logger logger = Logger.getLogger(JmxUtils.class);

    public static ModelMBean createModelMBean(Object o) {
        try {
            RequiredModelMBean mbean = new RequiredModelMBean();
            JmxManaged annotation = o.getClass().getAnnotation(JmxManaged.class);
            String description = annotation == null ? "" : annotation.description();
            ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(o.getClass().getName(), description, JmxUtils.extractAttributeInfo(o), new ModelMBeanConstructorInfo[0], JmxUtils.extractOperationInfo(o), new ModelMBeanNotificationInfo[0]);
            mbean.setModelMBeanInfo(info);
            mbean.setManagedResource(o, "ObjectReference");
            return mbean;
        }
        catch (MBeanException e) {
            throw new VoldemortException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new VoldemortException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new VoldemortException(e);
        }
    }

    public static ModelMBeanOperationInfo[] extractOperationInfo(Object object) {
        ArrayList<ModelMBeanOperationInfo> infos = new ArrayList<ModelMBeanOperationInfo>();
        for (Method m : object.getClass().getMethods()) {
            JmxOperation jmxOperation = m.getAnnotation(JmxOperation.class);
            JmxGetter jmxGetter = m.getAnnotation(JmxGetter.class);
            JmxSetter jmxSetter = m.getAnnotation(JmxSetter.class);
            if (jmxOperation == null && jmxGetter == null && jmxSetter == null) continue;
            String description = "";
            int visibility = 1;
            int impact = 3;
            if (jmxOperation != null) {
                description = jmxOperation.description();
                impact = jmxOperation.impact();
            } else if (jmxGetter != null) {
                description = jmxGetter.description();
                impact = 0;
                visibility = 4;
            } else if (jmxSetter != null) {
                description = jmxSetter.description();
                impact = 1;
                visibility = 4;
            }
            ModelMBeanOperationInfo info = new ModelMBeanOperationInfo(m.getName(), description, JmxUtils.extractParameterInfo(m), m.getReturnType().getName(), impact);
            info.getDescriptor().setField("visibility", Integer.toString(visibility));
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanOperationInfo[infos.size()]);
    }

    public static ModelMBeanAttributeInfo[] extractAttributeInfo(Object object) {
        Object setter;
        Object getter;
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        HashMap<String, String> descriptions = new HashMap<String, String>();
        for (Method m : object.getClass().getMethods()) {
            getter = m.getAnnotation(JmxGetter.class);
            if (getter != null) {
                getters.put(getter.name(), m);
                descriptions.put(getter.name(), getter.description());
            }
            if ((setter = m.getAnnotation(JmxSetter.class)) == null) continue;
            setters.put(setter.name(), m);
            descriptions.put(setter.name(), setter.description());
        }
        HashSet attributes = new HashSet(getters.keySet());
        attributes.addAll(setters.keySet());
        ArrayList<ModelMBeanAttributeInfo> infos = new ArrayList<ModelMBeanAttributeInfo>();
        for (String name : attributes) {
            try {
                getter = (Method)getters.get(name);
                setter = (Method)setters.get(name);
                ModelMBeanAttributeInfo info = new ModelMBeanAttributeInfo(name, (String)descriptions.get(name), (Method)getter, (Method)setter);
                Descriptor descriptor = info.getDescriptor();
                if (getter != null) {
                    descriptor.setField("getMethod", ((Method)getter).getName());
                }
                if (setter != null) {
                    descriptor.setField("setMethod", ((Method)setter).getName());
                }
                info.setDescriptor(descriptor);
                infos.add(info);
            }
            catch (IntrospectionException e) {
                throw new VoldemortException(e);
            }
        }
        return infos.toArray(new ModelMBeanAttributeInfo[infos.size()]);
    }

    public static MBeanParameterInfo[] extractParameterInfo(Method m) {
        Class<?>[] types = m.getParameterTypes();
        Annotation[][] annotations = m.getParameterAnnotations();
        MBeanParameterInfo[] params = new MBeanParameterInfo[types.length];
        for (int i = 0; i < params.length; ++i) {
            boolean hasAnnotation = false;
            for (int j = 0; j < annotations[i].length; ++j) {
                if (!(annotations[i][j] instanceof JmxParam)) continue;
                JmxParam param = (JmxParam)annotations[i][j];
                params[i] = new MBeanParameterInfo(param.name(), types[i].getName(), param.description());
                hasAnnotation = true;
                break;
            }
            if (hasAnnotation) continue;
            params[i] = new MBeanParameterInfo("", types[i].getName(), "");
        }
        return params;
    }

    public static ObjectName createObjectName(String domain, String type) {
        try {
            return new ObjectName(domain + ":type=" + type);
        }
        catch (MalformedObjectNameException e) {
            throw new VoldemortException(e);
        }
    }

    public static ObjectName createObjectName(Class<?> c) {
        return JmxUtils.createObjectName(JmxUtils.getPackageName(c), JmxUtils.getClassName(c));
    }

    public static String getPackageName(Class<?> c) {
        String name = c.getName();
        return name.substring(0, name.lastIndexOf(46));
    }

    public static String getClassName(Class<?> c) {
        String name = c.getName();
        return name.substring(name.lastIndexOf(46) + 1, name.length());
    }

    public static void registerMbean(Object mbean, ObjectName name) {
        JmxUtils.registerMbean(ManagementFactory.getPlatformMBeanServer(), JmxUtils.createModelMBean(mbean), name);
    }

    public static ObjectName registerMbean(String typeName, Object obj) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = JmxUtils.createObjectName(JmxUtils.getPackageName(obj.getClass()), typeName);
        JmxUtils.registerMbean(server, JmxUtils.createModelMBean(obj), name);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMbean(MBeanServer server, ModelMBean mbean, ObjectName name) {
        try {
            Object object = LOCK;
            synchronized (object) {
                if (server.isRegistered(name)) {
                    JmxUtils.unregisterMbean(server, name);
                }
                server.registerMBean(mbean, name);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error registering mbean:", (Throwable)e);
        }
    }

    public static void unregisterMbean(MBeanServer server, ObjectName name) {
        try {
            server.unregisterMBean(name);
        }
        catch (Exception e) {
            logger.error((Object)"Error unregistering mbean", (Throwable)e);
        }
    }

    public static void unregisterMbean(ObjectName name) {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(name);
        }
        catch (Exception e) {
            logger.error((Object)"Error unregistering mbean", (Throwable)e);
        }
    }
}

