/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.NumberFormat;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapreduce.ID;

class JVMId
extends org.apache.hadoop.mapred.ID {
    boolean isMap;
    JobID jobId;
    private static final String JVM = "jvm";
    private static NumberFormat idFormat = NumberFormat.getInstance();

    public JVMId(JobID jobId, boolean isMap, int id) {
        super(id);
        this.isMap = isMap;
        this.jobId = jobId;
    }

    public JVMId(String jtIdentifier, int jobId, boolean isMap, int id) {
        this(new JobID(jtIdentifier, jobId), isMap, id);
    }

    public JVMId() {
        this.jobId = new JobID();
    }

    public boolean isMapJVM() {
        return this.isMap;
    }

    public JobID getJobId() {
        return this.jobId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(JVMId.class)) {
            JVMId that = (JVMId)o;
            return this.id == that.id && this.isMap == that.isMap && this.jobId.equals(that.jobId);
        }
        return false;
    }

    @Override
    public int compareTo(ID o) {
        JVMId that = (JVMId)o;
        int jobComp = this.jobId.compareTo(that.jobId);
        if (jobComp == 0) {
            if (this.isMap == that.isMap) {
                return this.id - that.id;
            }
            return this.isMap ? -1 : 1;
        }
        return jobComp;
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder(JVM)).toString();
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        return this.jobId.appendTo(builder).append('_').append(this.isMap ? (char)'m' : 'r').append('_').append(idFormat.format(this.id));
    }

    @Override
    public int hashCode() {
        return this.jobId.hashCode() * 11 + this.id;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.jobId.readFields(in);
        this.isMap = in.readBoolean();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.jobId.write(out);
        out.writeBoolean(this.isMap);
    }

    public static JVMId forName(String str) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        try {
            String[] parts = str.split("_");
            if (parts.length == 5 && parts[0].equals(JVM)) {
                boolean isMap = false;
                if (parts[3].equals("m")) {
                    isMap = true;
                } else if (parts[3].equals("r")) {
                    isMap = false;
                } else {
                    throw new Exception();
                }
                return new JVMId(parts[1], Integer.parseInt(parts[2]), isMap, Integer.parseInt(parts[4]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("TaskId string : " + str + " is not properly formed");
    }

    static {
        idFormat.setGroupingUsed(false);
        idFormat.setMinimumIntegerDigits(6);
    }
}

