/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanVisitor;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepthFirstWalker<O extends Operator, P extends OperatorPlan<O>>
extends PlanWalker<O, P> {
    public DepthFirstWalker(P plan) {
        super(plan);
    }

    @Override
    public void walk(PlanVisitor<O, P> visitor) throws VisitorException {
        List roots = this.mPlan.getRoots();
        HashSet seen = new HashSet();
        this.depthFirst(null, roots, seen, visitor);
    }

    @Override
    public PlanWalker<O, P> spawnChildWalker(P plan) {
        return new DepthFirstWalker<O, P>(plan);
    }

    private void depthFirst(O node, Collection<O> successors, Set<O> seen, PlanVisitor<O, P> visitor) throws VisitorException {
        if (successors == null) {
            return;
        }
        for (Operator suc : successors) {
            if (!seen.add(suc)) continue;
            suc.visit(visitor);
            Collection<Operator> newSuccessors = Utils.mergeCollection(this.mPlan.getSuccessors(suc), this.mPlan.getSoftLinkSuccessors(suc));
            this.depthFirst(suc, newSuccessors, seen, visitor);
        }
    }
}

