/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.bdb;

import com.sleepycat.je.Environment;
import com.sleepycat.je.util.DbBackup;
import com.sleepycat.je.util.LogVerificationInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import voldemort.VoldemortException;
import voldemort.server.protocol.admin.AsyncOperationStatus;

public class BdbNativeBackup {
    private static final String BDB_EXT = ".jdb";
    private static final int LOGVERIFY_BUFSIZE = 1024;
    private final Environment env;
    private final File databaseDir;
    private final boolean verifyFiles;
    private final boolean isIncremental;
    private DbBackup backupHelper;

    public BdbNativeBackup(Environment env, boolean verifyFiles, boolean isIncremental) {
        this.env = env;
        this.verifyFiles = verifyFiles;
        this.isIncremental = isIncremental;
        this.databaseDir = env.getHome();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performBackup(File backupDir, AsyncOperationStatus status) {
        Long lastFileInPrevBackup = this.determineLastFile(backupDir, status);
        try {
            this.backupHelper = lastFileInPrevBackup == null ? new DbBackup(this.env) : new DbBackup(this.env, lastFileInPrevBackup.longValue());
            this.backupHelper.startBackup();
            try {
                String[] filesForBackup = this.backupHelper.getLogFilesInBackupSet();
                this.backupFiles(filesForBackup, backupDir, status);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.backupHelper.endBackup();
                throw throwable;
            }
            this.backupHelper.endBackup();
            {
            }
        }
        catch (Exception e) {
            throw new VoldemortException("Error performing native backup", e);
        }
    }

    private Long determineLastFile(File backupDir, final AsyncOperationStatus status) {
        status.setStatus("Determining the last backed up file...");
        File[] backupFiles = backupDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (!name.endsWith(BdbNativeBackup.BDB_EXT)) {
                    return false;
                }
                String part = name.substring(0, name.length() - BdbNativeBackup.BDB_EXT.length());
                try {
                    Long.parseLong(part, 16);
                }
                catch (NumberFormatException nfe) {
                    status.setStatus("Warning: .jdb file whose name is not a number, ignoring: " + name);
                    return false;
                }
                return true;
            }
        });
        if (backupFiles.length == 0) {
            status.setStatus("No backup files found, assuming a full backup is required.");
            return null;
        }
        long largest = Long.MIN_VALUE;
        for (File file : backupFiles) {
            long value = BdbNativeBackup.fileNameToNumber(file.getName());
            if (value <= largest) continue;
            largest = value;
        }
        status.setStatus("Last backed up file was " + largest);
        return largest;
    }

    private void backupFiles(String[] filesForBackup, File backupDir, AsyncOperationStatus status) {
        long size = 0L;
        for (String name : filesForBackup) {
            size += new File(this.databaseDir, name).length();
        }
        status.setStatus(String.format("Backing up %d files with a total of %.1fMB", filesForBackup.length, BdbNativeBackup.mb(size)));
        Arrays.sort(filesForBackup, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                long result = BdbNativeBackup.fileNameToNumber(o1) - BdbNativeBackup.fileNameToNumber(o2);
                if (result < 0L) {
                    return -1;
                }
                if (result > 0L) {
                    return 1;
                }
                return 0;
            }
        });
        long total = 0L;
        for (String name : filesForBackup) {
            File source = new File(this.databaseDir, name);
            File dest = new File(backupDir, name);
            status.setStatus(String.format("% 3d%% Copying %s", total * 100L / size, name));
            try {
                if (this.verifyFiles) {
                    this.verifiedCopyFile(source, dest);
                } else {
                    this.copyFile(source, dest);
                }
            }
            catch (IOException e) {
                if (dest.exists()) {
                    dest.delete();
                }
                throw new VoldemortException("Error occured while copying " + name + ". Deleting to ensure we don't have a corrupt backup.", e);
            }
            total += source.length();
        }
        if (this.isIncremental) {
            try {
                this.recordBackupSet(backupDir);
            }
            catch (IOException e) {
                throw new VoldemortException("Error attempting to write backup records for ", e);
            }
        } else {
            this.cleanStaleFiles(backupDir, status);
        }
    }

    private void recordBackupSet(File backupDir) throws IOException {
        String[] filesInEnv = this.env.getHome().list();
        SimpleDateFormat format = new SimpleDateFormat("yyyy_MM_dd_kk_mm_ss");
        String recordFileName = "backupset-" + format.format(new Date());
        File recordFile = new File(backupDir, recordFileName);
        if (recordFile.exists()) {
            recordFile.renameTo(new File(backupDir, recordFileName + ".old"));
        }
        PrintStream backupRecord = new PrintStream(new FileOutputStream(recordFile));
        backupRecord.println("Lastfile:" + Long.toHexString(this.backupHelper.getLastFileInBackupSet()));
        if (filesInEnv != null) {
            for (String file : filesInEnv) {
                if (!file.endsWith(BDB_EXT)) continue;
                backupRecord.println(file);
            }
        }
        backupRecord.close();
    }

    private void cleanStaleFiles(File backupDir, AsyncOperationStatus status) {
        String[] filesInEnv = this.env.getHome().list();
        String[] filesInBackupDir = backupDir.list();
        if (filesInEnv != null && filesInBackupDir != null) {
            HashSet<String> envFileSet = new HashSet<String>();
            for (String file : filesInEnv) {
                envFileSet.add(file);
            }
            for (String file : filesInBackupDir) {
                if (!file.endsWith(BDB_EXT) || envFileSet.contains(file)) continue;
                status.setStatus("Deleting stale jdb file :" + file);
                File staleJdbFile = new File(backupDir, file);
                staleJdbFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File sourceFile, File destFile) throws IOException {
        AbstractInterruptibleChannel destination;
        block6: {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            FileChannel source = null;
            destination = null;
            try {
                source = new FileInputStream(sourceFile).getChannel();
                destination = new FileOutputStream(destFile).getChannel();
                ((FileChannel)destination).transferFrom(source, 0L, source.size());
                Object var6_5 = null;
                if (source == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (source != null) {
                    source.close();
                }
                if (destination != null) {
                    destination.close();
                }
                throw throwable;
            }
            source.close();
        }
        if (destination != null) {
            destination.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifiedCopyFile(File sourceFile, File destFile) throws IOException {
        FileOutputStream destination;
        block7: {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            FileInputStream source = null;
            destination = null;
            LogVerificationInputStream verifyStream = null;
            try {
                int len;
                source = new FileInputStream(sourceFile);
                destination = new FileOutputStream(destFile);
                verifyStream = new LogVerificationInputStream(this.env, (InputStream)source, sourceFile.getName());
                byte[] buf = new byte[1024];
                while ((len = verifyStream.read(buf)) >= 0) {
                    destination.write(buf, 0, len);
                }
                Object var9_8 = null;
                if (verifyStream == null) break block7;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (verifyStream != null) {
                    verifyStream.close();
                }
                if (destination != null) {
                    destination.close();
                }
                throw throwable;
            }
            verifyStream.close();
        }
        if (destination != null) {
            destination.close();
        }
    }

    private static long fileNameToNumber(String name) {
        String part = name.substring(0, name.length() - BDB_EXT.length());
        return Long.parseLong(part, 16);
    }

    private static double mb(long value) {
        return (double)value / 1048576.0;
    }
}

