/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.logging;

import java.util.List;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.store.DelegatingStore;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.utils.SystemTime;
import voldemort.utils.Time;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingStore<K, V, T>
extends DelegatingStore<K, V, T> {
    private final Logger logger;
    private final Time time;
    private final String instanceName;

    public LoggingStore(Store<K, V, T> store) {
        this(store, new SystemTime());
    }

    public LoggingStore(Store<K, V, T> store, Time time) {
        this(store, null, time);
    }

    public LoggingStore(Store<K, V, T> store, String instance, Time time) {
        super(store);
        this.logger = Logger.getLogger(store.getClass());
        this.time = time;
        this.instanceName = instance == null ? ": " : instance + ": ";
    }

    @Override
    public void close() throws VoldemortException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Closing " + this.getName() + "."));
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(K key, Version version) throws VoldemortException {
        long startTimeNs = 0L;
        boolean succeeded = false;
        if (this.logger.isDebugEnabled()) {
            startTimeNs = this.time.getNanoseconds();
        }
        try {
            boolean deletedSomething = this.getInnerStore().delete(key, version);
            succeeded = true;
            boolean bl = deletedSomething;
            Object var9_7 = null;
            this.printTimedMessage("DELETE", succeeded, startTimeNs);
            return bl;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.printTimedMessage("DELETE", succeeded, startTimeNs);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Versioned<V>> get(K key, T transform) throws VoldemortException {
        long startTimeNs = 0L;
        boolean succeeded = false;
        if (this.logger.isDebugEnabled()) {
            startTimeNs = this.time.getNanoseconds();
        }
        try {
            List l = this.getInnerStore().get(key, transform);
            succeeded = true;
            List list = l;
            Object var9_7 = null;
            this.printTimedMessage("GET", succeeded, startTimeNs);
            return list;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.printTimedMessage("GET", succeeded, startTimeNs);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, Versioned<V> value, T transform) throws VoldemortException {
        long startTimeNs = 0L;
        boolean succeeded = false;
        if (this.logger.isDebugEnabled()) {
            startTimeNs = this.time.getNanoseconds();
        }
        try {
            this.getInnerStore().put(key, value, transform);
            succeeded = true;
            Object var8_6 = null;
            this.printTimedMessage("PUT", succeeded, startTimeNs);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.printTimedMessage("PUT", succeeded, startTimeNs);
            throw throwable;
        }
    }

    private void printTimedMessage(String operation, boolean success, long startNs) {
        if (this.logger.isDebugEnabled()) {
            double elapsedMs = (double)(this.time.getNanoseconds() - startNs) / 1000000.0;
            this.logger.debug((Object)(this.instanceName + operation + " " + this.getName() + " " + (success ? "successful" : "unsuccessful") + " in " + elapsedMs + " ms"));
        }
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        if (capability == StoreCapabilityType.LOGGER) {
            return this.logger;
        }
        return this.getInnerStore().getCapability(capability);
    }
}

