/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import voldemort.client.protocol.RequestFormatType;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.protocol.admin.AdminClientConfig;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.routing.RoutingStrategy;
import voldemort.routing.RoutingStrategyFactory;
import voldemort.server.RequestRoutingType;
import voldemort.store.Store;
import voldemort.store.StoreDefinition;
import voldemort.store.socket.clientrequest.ClientRequestExecutorPool;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteUtils;
import voldemort.utils.CmdUtils;
import voldemort.utils.RebalanceUtils;
import voldemort.utils.Utils;
import voldemort.xml.ClusterMapper;
import voldemort.xml.StoreDefinitionsMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entropy {
    private int nodeId;
    private long numKeys;
    private boolean verboseLogging;
    public static long DEFAULT_NUM_KEYS = 10000L;

    public Entropy(int nodeId) {
        this.nodeId = nodeId;
        this.numKeys = DEFAULT_NUM_KEYS;
        this.verboseLogging = false;
    }

    public Entropy(int nodeId, long numKeys, boolean verboseLogging) {
        this.nodeId = nodeId;
        this.numKeys = numKeys;
        this.verboseLogging = verboseLogging;
    }

    public static void main(String[] args) throws IOException {
        Set<String> missing;
        OptionParser parser = new OptionParser();
        parser.accepts("help", "print help information");
        parser.accepts("node", "Node id").withRequiredArg().describedAs("node-id").ofType(Integer.class);
        parser.accepts("cluster-xml", "[REQUIRED] Path to cluster-xml").withRequiredArg().describedAs("xml").ofType(String.class);
        parser.accepts("stores-xml", "[REQUIRED] Path to stores-xml").withRequiredArg().describedAs("xml").ofType(String.class);
        parser.accepts("output-dir", "[REQUIRED] The output directory where we'll store / retrieve the keys. ").withRequiredArg().describedAs("output-dir").ofType(String.class);
        parser.accepts("op-type", "Operation type - false ( save keys ) [ default ], true ( run entropy calculator ) ").withRequiredArg().ofType(Boolean.class);
        parser.accepts("num-keys", "Number of keys per store [ Default: " + DEFAULT_NUM_KEYS + " ]").withRequiredArg().describedAs("keys").ofType(Long.class);
        parser.accepts("negative-test", "Check for keys that dont belong on the given nodeId are not present");
        parser.accepts("verbose-logging", "Verbose logging such as keys found missing on specific nodes");
        OptionSet options = parser.parse(args);
        boolean negativeTest = false;
        if (options.has("negative-test")) {
            negativeTest = true;
        }
        if (options.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        if ((missing = CmdUtils.missing(options, "cluster-xml", "stores-xml", "output-dir")).size() > 0) {
            System.err.println("Missing required arguments: " + Joiner.on((String)", ").join(missing));
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        String clusterXml = (String)options.valueOf("cluster-xml");
        String storesXml = (String)options.valueOf("stores-xml");
        String outputDirPath = (String)options.valueOf("output-dir");
        long numKeys = CmdUtils.valueOf(options, "num-keys", Long.valueOf(DEFAULT_NUM_KEYS));
        int nodeId = CmdUtils.valueOf(options, "node", Integer.valueOf(0));
        boolean opType = CmdUtils.valueOf(options, "op-type", Boolean.valueOf(false));
        boolean verboseLogging = options.has("verbose-logging");
        File outputDir = new File(outputDirPath);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        } else if (!outputDir.isDirectory() || !outputDir.canWrite()) {
            System.err.println("Cannot write to output directory " + outputDirPath);
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        if (!Utils.isReadableFile(clusterXml) || !Utils.isReadableFile(storesXml)) {
            System.err.println("Cannot read metadata file ");
            System.exit(1);
        }
        Cluster cluster = new ClusterMapper().readCluster(new File(clusterXml));
        List<StoreDefinition> storeDefs = new StoreDefinitionsMapper().readStoreList(new File(storesXml));
        Entropy detector = new Entropy(nodeId, numKeys, verboseLogging);
        detector.generateEntropy(cluster, storeDefs, outputDir, opType, negativeTest);
    }

    public void generateEntropy(Cluster cluster, List<StoreDefinition> storeDefs, File storeDir, boolean opType) throws IOException {
        this.generateEntropy(cluster, storeDefs, storeDir, opType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEntropy(Cluster cluster, List<StoreDefinition> storeDefs, File storeDir, boolean opType, boolean negativeTest) throws IOException {
        AdminClient adminClient = null;
        try {
            adminClient = new AdminClient(cluster, new AdminClientConfig().setMaxConnectionsPerNode(storeDefs.size()));
            if (opType) {
                System.out.println("Running entropy calculator");
            } else {
                System.out.println("Generating keys for future entropy calculation");
                Utils.mkdirs(storeDir);
            }
            for (StoreDefinition storeDef : storeDefs) {
                HashMap socketStoresPerNode;
                block38: {
                    Object var29_40;
                    File storesKeyFile = new File(storeDir, storeDef.getName());
                    if (AdminClient.restoreStoreEngineBlackList.contains(storeDef.getType())) {
                        System.out.println("Ignoring store " + storeDef.getName());
                        continue;
                    }
                    System.out.println("Working on store " + storeDef.getName());
                    RoutingStrategy strategy = new RoutingStrategyFactory().updateRoutingStrategy(storeDef, cluster);
                    if (!opType) {
                        Object var21_32;
                        if (storesKeyFile.exists()) {
                            System.err.println("Key files for " + storeDef.getName() + " already exists");
                            continue;
                        }
                        FileOutputStream writer = null;
                        try {
                            writer = new FileOutputStream(storesKeyFile);
                            Iterator<ByteArray> keys = null;
                            if (this.nodeId == -1) {
                                int numKeysPerNode = (int)Math.floor(this.numKeys / (long)cluster.getNumberOfNodes());
                                for (Node node : cluster.getNodes()) {
                                    keys = adminClient.fetchKeys(node.getId(), storeDef.getName(), cluster.getNodeById(node.getId()).getPartitionIds(), null, false);
                                    for (long keyId = 0L; keyId < (long)numKeysPerNode && keys.hasNext(); ++keyId) {
                                        ByteArray key = keys.next();
                                        if (!RebalanceUtils.getNodeIds(strategy.routeRequest(key.get()).subList(0, 1)).contains(node.getId())) continue;
                                        writer.write(key.length());
                                        writer.write(key.get());
                                    }
                                }
                            } else {
                                List<Integer> partitions = cluster.getNodeById(this.nodeId).getPartitionIds();
                                HashMap<Integer, Integer> partitionMap = new HashMap<Integer, Integer>();
                                int numKeysPerPartition = (int)Math.floor(this.numKeys / (long)partitions.size());
                                int numKeysStored = 0;
                                for (int partitionId : partitions) {
                                    partitionMap.put(partitionId, 0);
                                }
                                keys = adminClient.fetchKeys(this.nodeId, storeDef.getName(), partitions, null, false);
                                while (keys.hasNext() && (long)numKeysStored < this.numKeys) {
                                    int targetPartition;
                                    int partitionCount;
                                    ByteArray key = keys.next();
                                    if (!RebalanceUtils.getNodeIds(strategy.routeRequest(key.get()).subList(0, 1)).contains(this.nodeId) || (partitionCount = ((Integer)partitionMap.get(targetPartition = strategy.getPartitionList(key.get()).get(0).intValue())).intValue()) == numKeysPerPartition) continue;
                                    writer.write(key.length());
                                    writer.write(key.get());
                                    partitionMap.put(targetPartition, partitionCount + 1);
                                    ++numKeysStored;
                                }
                                System.out.println("Total partitions filled : " + partitions.size());
                                for (int partitionId : partitions) {
                                    System.out.println("Count in partition #" + partitionId + " = " + partitionMap.get(partitionId));
                                }
                            }
                            var21_32 = null;
                            if (writer == null) continue;
                        }
                        catch (Throwable throwable) {
                            var21_32 = null;
                            if (writer != null) {
                                writer.close();
                            }
                            throw throwable;
                        }
                        writer.close();
                        {
                            continue;
                        }
                    }
                    if (negativeTest && this.nodeId == -1) {
                        Object var33_43 = null;
                        if (adminClient != null) {
                            adminClient.stop();
                        }
                        return;
                    }
                    if (!storesKeyFile.exists() || !storesKeyFile.canRead()) {
                        System.err.println("Could not find " + storeDef.getName() + " file to check");
                        continue;
                    }
                    FileInputStream reader = null;
                    ClientRequestExecutorPool socketStoreFactory = new ClientRequestExecutorPool(2, 10000, 100000, 32768);
                    socketStoresPerNode = Maps.newHashMap();
                    for (Node node : cluster.getNodes()) {
                        socketStoresPerNode.put(node.getId(), socketStoreFactory.create(storeDef.getName(), node.getHost(), node.getSocketPort(), RequestFormatType.PROTOCOL_BUFFERS, RequestRoutingType.IGNORE_CHECKS));
                    }
                    long deletedKeys = 0L;
                    long foundKeys = 0L;
                    long totalKeys = 0L;
                    try {
                        int size;
                        reader = new FileInputStream(storesKeyFile);
                        while (reader.available() != 0 && (size = reader.read()) > 0) {
                            byte[] key = new byte[size];
                            reader.read(key);
                            List<Node> responsibleNodes = strategy.routeRequest(key);
                            if (!negativeTest) {
                                boolean missingKey = false;
                                for (Node node : responsibleNodes) {
                                    List value = ((Store)socketStoresPerNode.get(node.getId())).get(new ByteArray(key), null);
                                    if (value != null && value.size() != 0) continue;
                                    missingKey = true;
                                    if (!this.verboseLogging) continue;
                                    String stringKey = ByteUtils.getString(key, "UTF-8");
                                    System.out.println("missing key=" + stringKey + " on node=" + node.getId());
                                    System.out.println("is value null " + (value == null ? "true" : "false"));
                                    System.out.println("is size zero " + (value.size() == 0 ? "true" : "false"));
                                }
                                if (!missingKey) {
                                    ++foundKeys;
                                }
                                ++totalKeys;
                                continue;
                            }
                            if (responsibleNodes.contains(cluster.getNodeById(this.nodeId))) continue;
                            List value = ((Store)socketStoresPerNode.get(this.nodeId)).get(new ByteArray(key), null);
                            if (value == null || value.size() == 0) {
                                ++deletedKeys;
                            }
                            ++totalKeys;
                        }
                        if (!negativeTest) {
                            System.out.println("Found = " + foundKeys + " Total = " + totalKeys);
                            if (foundKeys > 0L && totalKeys > 0L) {
                                System.out.println("%age found - " + 100.0 * (double)foundKeys / (double)totalKeys);
                            }
                        } else {
                            System.out.println("Deleted = " + deletedKeys + " Total = " + totalKeys);
                            if (deletedKeys > 0L && totalKeys > 0L) {
                                System.out.println("%age deleted - " + 100.0 * (double)deletedKeys / (double)totalKeys);
                            }
                        }
                        var29_40 = null;
                        if (reader == null) break block38;
                    }
                    catch (Throwable throwable) {
                        var29_40 = null;
                        if (reader != null) {
                            reader.close();
                        }
                        for (Store store : socketStoresPerNode.values()) {
                            store.close();
                        }
                        throw throwable;
                    }
                    reader.close();
                }
                for (Store store : socketStoresPerNode.values()) {
                    store.close();
                }
            }
        }
        catch (Throwable throwable) {
            Object var33_45 = null;
            if (adminClient != null) {
                adminClient.stop();
            }
            throw throwable;
        }
        Object var33_44 = null;
        if (adminClient != null) {
            adminClient.stop();
        }
    }
}

