/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigTupleDefaultRawComparator;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.data.TupleRawComparator;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.util.ObjectSerializer;

public class PigTupleSortComparator
extends WritableComparator
implements Configurable {
    private final Log mLog = LogFactory.getLog(((Object)((Object)this)).getClass());
    private boolean[] mAsc;
    private boolean mWholeTuple;
    private TupleRawComparator mComparator = null;

    public PigTupleSortComparator() {
        super(TupleFactory.getInstance().tupleClass());
    }

    public void setConf(Configuration conf) {
        if (!(conf instanceof JobConf)) {
            this.mLog.warn((Object)("Expected jobconf in setConf, got " + conf.getClass().getName()));
            return;
        }
        JobConf jconf = (JobConf)conf;
        try {
            this.mAsc = (boolean[])ObjectSerializer.deserialize(jconf.get("pig.sortOrder"));
        }
        catch (IOException ioe) {
            this.mLog.error((Object)("Unable to deserialize pig.sortOrder " + ioe.getMessage()));
            throw new RuntimeException(ioe);
        }
        if (this.mAsc == null) {
            this.mAsc = new boolean[1];
            this.mAsc[0] = true;
        }
        this.mWholeTuple = this.mAsc.length == 1;
        try {
            Class<? extends TupleRawComparator> mComparatorClass = TupleFactory.getInstance().tupleRawComparatorClass();
            if (mComparatorClass != null) {
                this.mComparator = mComparatorClass.newInstance();
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (AbstractMethodError e) {
            // empty catch block
        }
        if (this.mComparator == null) {
            try {
                this.mComparator = (TupleRawComparator)PigTupleDefaultRawComparator.class.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        this.mComparator.setConf((Configuration)jconf);
    }

    public Configuration getConf() {
        return null;
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int rc = 0;
        if (b1[s1] == 0 && b2[s2] == 0) {
            rc = this.mComparator.compare(b1, s1 + 1, l1 - 2, b2, s2 + 1, l2 - 2);
        } else {
            rc = b1[s1] != 0 && b2[s2] != 0 ? 0 : (b1[s1] != 0 ? -1 : 1);
            if (this.mWholeTuple && !this.mAsc[0]) {
                rc *= -1;
            }
        }
        return rc;
    }

    public int compare(Object o1, Object o2) {
        NullableTuple nt1 = (NullableTuple)o1;
        NullableTuple nt2 = (NullableTuple)o2;
        int rc = 0;
        if (!nt1.isNull() && !nt2.isNull()) {
            rc = this.mComparator.compare((Tuple)nt1.getValueAsPigType(), (Tuple)nt2.getValueAsPigType());
        } else {
            rc = nt1.isNull() && nt2.isNull() ? 0 : (nt1.isNull() ? -1 : 1);
            if (this.mWholeTuple && !this.mAsc[0]) {
                rc *= -1;
            }
        }
        return rc;
    }

    private int compareTuple(Tuple t1, Tuple t2) {
        int sz1 = t1.size();
        int sz2 = t2.size();
        if (sz2 < sz1) {
            return 1;
        }
        if (sz2 > sz1) {
            return -1;
        }
        for (int i = 0; i < sz1; ++i) {
            try {
                int c = DataType.compare(t1.get(i), t2.get(i));
                if (c == 0) continue;
                if (!this.mWholeTuple && !this.mAsc[i]) {
                    c *= -1;
                } else if (this.mWholeTuple && !this.mAsc[0]) {
                    c *= -1;
                }
                return c;
            }
            catch (ExecException e) {
                throw new RuntimeException("Unable to compare tuples", e);
            }
        }
        return 0;
    }
}

