/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.avro.io.Encoder;
import org.apache.avro.ipc.ByteBufferOutputStream;
import org.apache.avro.util.Utf8;

public class BinaryEncoder
extends Encoder {
    protected OutputStream out;
    private final ByteWriter byteWriter;

    public BinaryEncoder(OutputStream out) {
        this.out = out;
        this.byteWriter = out instanceof ByteBufferOutputStream ? new ReuseByteWriter((ByteBufferOutputStream)out) : new SimpleByteWriter(out);
    }

    @Override
    public void init(OutputStream out) throws IOException {
        this.flush();
        this.out = out;
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    @Override
    public void writeNull() throws IOException {
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        this.out.write(b ? 1 : 0);
    }

    @Override
    public void writeInt(int n) throws IOException {
        BinaryEncoder.encodeLong(n, this.out);
    }

    @Override
    public void writeLong(long n) throws IOException {
        BinaryEncoder.encodeLong(n, this.out);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        BinaryEncoder.encodeFloat(f, this.out);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        BinaryEncoder.encodeDouble(d, this.out);
    }

    @Override
    public void writeString(Utf8 utf8) throws IOException {
        this.encodeString(utf8.getBytes(), 0, utf8.getByteLength());
    }

    @Override
    public void writeString(String string) throws IOException {
        byte[] bytes = Utf8.getBytesFor(string);
        this.encodeString(bytes, 0, bytes.length);
    }

    private void encodeString(byte[] bytes, int offset, int length) throws IOException {
        BinaryEncoder.encodeLong(length, this.out);
        this.out.write(bytes, offset, length);
    }

    @Override
    public void writeBytes(ByteBuffer bytes) throws IOException {
        this.byteWriter.write(bytes);
    }

    @Override
    public void writeBytes(byte[] bytes, int start, int len) throws IOException {
        BinaryEncoder.encodeLong(len, this.out);
        this.out.write(bytes, start, len);
    }

    @Override
    public void writeFixed(byte[] bytes, int start, int len) throws IOException {
        this.out.write(bytes, start, len);
    }

    @Override
    public void writeEnum(int e) throws IOException {
        BinaryEncoder.encodeLong(e, this.out);
    }

    @Override
    public void writeArrayStart() throws IOException {
    }

    @Override
    public void setItemCount(long itemCount) throws IOException {
        if (itemCount > 0L) {
            this.writeLong(itemCount);
        }
    }

    @Override
    public void startItem() throws IOException {
    }

    @Override
    public void writeArrayEnd() throws IOException {
        BinaryEncoder.encodeLong(0L, this.out);
    }

    @Override
    public void writeMapStart() throws IOException {
    }

    @Override
    public void writeMapEnd() throws IOException {
        BinaryEncoder.encodeLong(0L, this.out);
    }

    @Override
    public void writeIndex(int unionIndex) throws IOException {
        BinaryEncoder.encodeLong(unionIndex, this.out);
    }

    protected static void encodeLong(long n, OutputStream o) throws IOException {
        n = n << 1 ^ n >> 63;
        while ((n & 0xFFFFFFFFFFFFFF80L) != 0L) {
            o.write((byte)(n & 0x7FL | 0x80L));
            n >>>= 7;
        }
        o.write((byte)n);
    }

    protected static int encodeLong(long n, byte[] b, int pos) {
        n = n << 1 ^ n >> 63;
        while ((n & 0xFFFFFFFFFFFFFF80L) != 0L) {
            b[pos++] = (byte)(n & 0x7FL | 0x80L);
            n >>>= 7;
        }
        b[pos++] = (byte)n;
        return pos;
    }

    protected static void encodeFloat(float f, OutputStream o) throws IOException {
        long bits = Float.floatToRawIntBits(f);
        o.write((int)bits & 0xFF);
        o.write((int)(bits >> 8) & 0xFF);
        o.write((int)(bits >> 16) & 0xFF);
        o.write((int)(bits >> 24) & 0xFF);
    }

    protected static int encodeFloat(float f, byte[] b, int pos) {
        long bits = Float.floatToRawIntBits(f);
        b[pos++] = (byte)(bits & 0xFFL);
        b[pos++] = (byte)(bits >> 8 & 0xFFL);
        b[pos++] = (byte)(bits >> 16 & 0xFFL);
        b[pos++] = (byte)(bits >> 24 & 0xFFL);
        return pos;
    }

    protected static void encodeDouble(double d, OutputStream o) throws IOException {
        long bits = Double.doubleToRawLongBits(d);
        o.write((int)bits & 0xFF);
        o.write((int)(bits >> 8) & 0xFF);
        o.write((int)(bits >> 16) & 0xFF);
        o.write((int)(bits >> 24) & 0xFF);
        o.write((int)(bits >> 32) & 0xFF);
        o.write((int)(bits >> 40) & 0xFF);
        o.write((int)(bits >> 48) & 0xFF);
        o.write((int)(bits >> 56) & 0xFF);
    }

    protected static int encodeDouble(double d, byte[] b, int pos) {
        long bits = Double.doubleToRawLongBits(d);
        b[pos++] = (byte)(bits & 0xFFL);
        b[pos++] = (byte)(bits >> 8 & 0xFFL);
        b[pos++] = (byte)(bits >> 16 & 0xFFL);
        b[pos++] = (byte)(bits >> 24 & 0xFFL);
        b[pos++] = (byte)(bits >> 32 & 0xFFL);
        b[pos++] = (byte)(bits >> 40 & 0xFFL);
        b[pos++] = (byte)(bits >> 48 & 0xFFL);
        b[pos++] = (byte)(bits >> 56 & 0xFFL);
        return pos;
    }

    private static final class ReuseByteWriter
    implements ByteWriter {
        private final ByteBufferOutputStream bbout;

        public ReuseByteWriter(ByteBufferOutputStream bbout) {
            this.bbout = bbout;
        }

        @Override
        public void write(ByteBuffer bytes) throws IOException {
            BinaryEncoder.encodeLong(bytes.remaining(), this.bbout);
            this.bbout.writeBuffer(bytes);
        }
    }

    private static final class SimpleByteWriter
    implements ByteWriter {
        private final OutputStream out;

        public SimpleByteWriter(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(ByteBuffer bytes) throws IOException {
            BinaryEncoder.encodeLong(bytes.remaining(), this.out);
            this.out.write(bytes.array(), bytes.position(), bytes.remaining());
        }
    }

    private static interface ByteWriter {
        public void write(ByteBuffer var1) throws IOException;
    }
}

