/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.PlanWalker;
import org.apache.pig.newplan.ReverseDependencyOrderWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverseDependencyOrderWalkerWOSeenChk
extends PlanWalker {
    public ReverseDependencyOrderWalkerWOSeenChk(OperatorPlan plan) {
        super(plan);
    }

    @Override
    public PlanWalker spawnChildWalker(OperatorPlan plan) {
        return new ReverseDependencyOrderWalker(plan);
    }

    @Override
    public void walk(PlanVisitor visitor) throws FrontendException {
        ArrayList<Operator> fifo = new ArrayList<Operator>();
        List<Operator> roots = this.plan.getSources();
        if (roots == null) {
            return;
        }
        for (Operator op : roots) {
            this.doAllSuccessors(op, fifo);
        }
        for (Operator op : fifo) {
            op.accept(visitor);
        }
    }

    protected void doAllSuccessors(Operator node, Collection<Operator> fifo) throws FrontendException {
        Collection<Operator> succs = Utils.mergeCollection(this.plan.getSuccessors(node), this.plan.getSoftLinkSuccessors(node));
        if (succs != null && succs.size() > 0) {
            for (Operator op : succs) {
                this.doAllSuccessors(op, fifo);
            }
        }
        fifo.add(node);
    }
}

