/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableJobInfo;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionReference;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.project.Project;
import azkaban.scheduler.ScheduleStatisticManager;
import azkaban.utils.FileIOUtils;
import azkaban.utils.JSONUtils;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;

public class ExecutorManagerRemoteAdapter
implements ExecutorManagerAdapter {
    private static Logger logger = Logger.getLogger(ExecutorManagerRemoteAdapter.class);
    private ExecutorLoader executorLoader;
    private String executorHost;
    private int executorPort;
    private String executorManagerHost;
    private int executorManagerPort;
    private ConcurrentHashMap<Integer, Pair<ExecutionReference, ExecutableFlow>> runningFlows = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, ExecutableFlow> recentlyFinished = new ConcurrentHashMap();
    private UpdaterThread updater;
    private long lastThreadCheckTime = -1L;

    public ExecutorManagerRemoteAdapter(Props props, ExecutorLoader loader) throws ExecutorManagerException {
        this.executorLoader = loader;
        this.loadRunningFlows();
        this.executorHost = props.getString("executor.host", "localhost");
        this.executorPort = props.getInt("executor.port");
        this.executorManagerHost = props.getString("remote.executor.manager.host");
        this.executorManagerPort = props.getInt("remote.executor.manager.port");
        this.updater = new UpdaterThread();
        this.updater.start();
    }

    @Override
    public Thread.State getExecutorManagerThreadState() {
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        params.add(new Pair<String, String>("jmxType", "getExecutorManagerThreadState"));
        try {
            Map<String, Object> response = this.callRemoteExecutorManager("getJMX", "azkaban", params);
            return (Thread.State)((Object)response.get("jmxData"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isExecutorManagerThreadActive() {
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        params.add(new Pair<String, String>("jmxType", "isExecutorManagerThreadActive"));
        try {
            Map<String, Object> response = this.callRemoteExecutorManager("getJMX", "azkaban", params);
            return (Boolean)response.get("jmxData");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public long getLastExecutorManagerThreadCheckTime() {
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        params.add(new Pair<String, String>("jmxType", "getLastExecutorManagerThreadCheckTime"));
        try {
            Map<String, Object> response = this.callRemoteExecutorManager("getJMX", "azkaban", params);
            return (Long)response.get("jmxData");
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public Set<String> getPrimaryServerHosts() {
        HashSet<String> ports = new HashSet<String>();
        ports.add(this.executorHost + ":" + this.executorPort);
        return ports;
    }

    @Override
    public Set<String> getAllActiveExecutorServerHosts() {
        HashSet<String> ports = new HashSet<String>();
        ports.add(this.executorHost + ":" + this.executorPort);
        for (Pair<ExecutionReference, ExecutableFlow> running : this.runningFlows.values()) {
            ExecutionReference ref = running.getFirst();
            ports.add(ref.getHost() + ":" + ref.getPort());
        }
        return ports;
    }

    private void loadRunningFlows() throws ExecutorManagerException {
        this.runningFlows.putAll(this.executorLoader.fetchActiveFlows());
    }

    @Override
    public List<Integer> getRunningFlows(int projectId, String flowId) {
        ArrayList<Integer> executionIds = new ArrayList<Integer>();
        for (Pair<ExecutionReference, ExecutableFlow> ref : this.runningFlows.values()) {
            if (!ref.getSecond().getFlowId().equals(flowId)) continue;
            executionIds.add(ref.getFirst().getExecId());
        }
        return executionIds;
    }

    @Override
    public boolean isFlowRunning(int projectId, String flowId) {
        for (Pair<ExecutionReference, ExecutableFlow> ref : this.runningFlows.values()) {
            if (ref.getSecond().getProjectId() != projectId || !ref.getSecond().getFlowId().equals(flowId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExecutableFlow getExecutableFlow(int execId) throws ExecutorManagerException {
        Pair<ExecutionReference, ExecutableFlow> active = this.runningFlows.get(execId);
        if (active == null) {
            return this.executorLoader.fetchExecutableFlow(execId);
        }
        return active.getSecond();
    }

    @Override
    public List<ExecutableFlow> getRunningFlows() {
        ArrayList<ExecutableFlow> flows = new ArrayList<ExecutableFlow>();
        for (Pair<ExecutionReference, ExecutableFlow> ref : this.runningFlows.values()) {
            flows.add(ref.getSecond());
        }
        return flows;
    }

    @Override
    public List<ExecutableFlow> getRecentlyFinishedFlows() {
        return new ArrayList<ExecutableFlow>(this.recentlyFinished.values());
    }

    @Override
    public List<ExecutableFlow> getExecutableFlows(Project project, String flowId, int skip, int size) throws ExecutorManagerException {
        List<ExecutableFlow> flows = this.executorLoader.fetchFlowHistory(project.getId(), flowId, skip, size);
        return flows;
    }

    @Override
    public List<ExecutableFlow> getExecutableFlows(int skip, int size) throws ExecutorManagerException {
        List<ExecutableFlow> flows = this.executorLoader.fetchFlowHistory(skip, size);
        return flows;
    }

    @Override
    public List<ExecutableFlow> getExecutableFlows(String flowIdContains, int skip, int size) throws ExecutorManagerException {
        List<ExecutableFlow> flows = this.executorLoader.fetchFlowHistory(null, '%' + flowIdContains + '%', null, 0, -1L, -1L, skip, size);
        return flows;
    }

    @Override
    public List<ExecutableFlow> getExecutableFlows(String projContain, String flowContain, String userContain, int status, long begin, long end, int skip, int size) throws ExecutorManagerException {
        List<ExecutableFlow> flows = this.executorLoader.fetchFlowHistory(projContain, flowContain, userContain, status, begin, end, skip, size);
        return flows;
    }

    @Override
    public List<ExecutableJobInfo> getExecutableJobs(Project project, String jobId, int skip, int size) throws ExecutorManagerException {
        List<ExecutableJobInfo> nodes = this.executorLoader.fetchJobHistory(project.getId(), jobId, skip, size);
        return nodes;
    }

    @Override
    public int getNumberOfJobExecutions(Project project, String jobId) throws ExecutorManagerException {
        return this.executorLoader.fetchNumExecutableNodes(project.getId(), jobId);
    }

    @Override
    public int getNumberOfExecutions(Project project, String flowId) throws ExecutorManagerException {
        return this.executorLoader.fetchNumExecutableFlows(project.getId(), flowId);
    }

    @Override
    public FileIOUtils.LogData getExecutableFlowLog(ExecutableFlow exFlow, int offset, int length) throws ExecutorManagerException {
        Pair<ExecutionReference, ExecutableFlow> pair = this.runningFlows.get(exFlow.getExecutionId());
        if (pair != null) {
            Pair<String, String> typeParam = new Pair<String, String>("type", "flow");
            Pair<String, String> offsetParam = new Pair<String, String>("offset", String.valueOf(offset));
            Pair<String, String> lengthParam = new Pair<String, String>("length", String.valueOf(length));
            Map<String, Object> result = this.callExecutorServer(pair.getFirst(), "log", typeParam, offsetParam, lengthParam);
            return FileIOUtils.LogData.createLogDataFromObject(result);
        }
        FileIOUtils.LogData value = this.executorLoader.fetchLogs(exFlow.getExecutionId(), "", 0, offset, length);
        return value;
    }

    @Override
    public FileIOUtils.LogData getExecutionJobLog(ExecutableFlow exFlow, String jobId, int offset, int length, int attempt) throws ExecutorManagerException {
        Pair<ExecutionReference, ExecutableFlow> pair = this.runningFlows.get(exFlow.getExecutionId());
        if (pair != null) {
            Pair<String, String> typeParam = new Pair<String, String>("type", "job");
            Pair<String, String> jobIdParam = new Pair<String, String>("jobId", jobId);
            Pair<String, String> offsetParam = new Pair<String, String>("offset", String.valueOf(offset));
            Pair<String, String> lengthParam = new Pair<String, String>("length", String.valueOf(length));
            Pair<String, String> attemptParam = new Pair<String, String>("attempt", String.valueOf(attempt));
            Map<String, Object> result = this.callExecutorServer(pair.getFirst(), "log", typeParam, jobIdParam, offsetParam, lengthParam, attemptParam);
            return FileIOUtils.LogData.createLogDataFromObject(result);
        }
        FileIOUtils.LogData value = this.executorLoader.fetchLogs(exFlow.getExecutionId(), jobId, attempt, offset, length);
        return value;
    }

    @Override
    public FileIOUtils.JobMetaData getExecutionJobMetaData(ExecutableFlow exFlow, String jobId, int offset, int length, int attempt) throws ExecutorManagerException {
        Pair<ExecutionReference, ExecutableFlow> pair = this.runningFlows.get(exFlow.getExecutionId());
        if (pair != null) {
            Pair<String, String> typeParam = new Pair<String, String>("type", "job");
            Pair<String, String> jobIdParam = new Pair<String, String>("jobId", jobId);
            Pair<String, String> offsetParam = new Pair<String, String>("offset", String.valueOf(offset));
            Pair<String, String> lengthParam = new Pair<String, String>("length", String.valueOf(length));
            Pair<String, String> attemptParam = new Pair<String, String>("attempt", String.valueOf(attempt));
            Map<String, Object> result = this.callExecutorServer(pair.getFirst(), "metadata", typeParam, jobIdParam, offsetParam, lengthParam, attemptParam);
            return FileIOUtils.JobMetaData.createJobMetaDataFromObject(result);
        }
        return null;
    }

    @Override
    public void cancelFlow(ExecutableFlow exFlow, String userId) throws ExecutorManagerException {
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        params.add(new Pair<String, String>("execId", String.valueOf(exFlow.getExecutionId())));
        try {
            Map<String, Object> response = this.callRemoteExecutorManager("cancelFlow", userId, params);
            if (response.containsKey("error")) {
                throw new ExecutorManagerException((String)response.get("error"));
            }
        }
        catch (Exception e) {
            throw new ExecutorManagerException(e);
        }
    }

    @Override
    public void resumeFlow(ExecutableFlow exFlow, String userId) throws ExecutorManagerException {
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        params.add(new Pair<String, String>("execId", String.valueOf(exFlow.getExecutionId())));
        try {
            Map<String, Object> response = this.callRemoteExecutorManager("resumeFlow", userId, params);
            if (response.containsKey("error")) {
                throw new ExecutorManagerException((String)response.get("error"));
            }
        }
        catch (Exception e) {
            throw new ExecutorManagerException(e);
        }
    }

    @Override
    public void pauseFlow(ExecutableFlow exFlow, String userId) throws ExecutorManagerException {
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        params.add(new Pair<String, String>("execId", String.valueOf(exFlow.getExecutionId())));
        try {
            Map<String, Object> response = this.callRemoteExecutorManager("pauseFlow", userId, params);
            if (response.containsKey("error")) {
                throw new ExecutorManagerException((String)response.get("error"));
            }
        }
        catch (Exception e) {
            throw new ExecutorManagerException(e);
        }
    }

    @Override
    public void pauseExecutingJobs(ExecutableFlow exFlow, String userId, String ... jobIds) throws ExecutorManagerException {
        this.modifyExecutingJobs(exFlow, "pauseJobs", userId, jobIds);
    }

    @Override
    public void resumeExecutingJobs(ExecutableFlow exFlow, String userId, String ... jobIds) throws ExecutorManagerException {
        this.modifyExecutingJobs(exFlow, "resumeJobs", userId, jobIds);
    }

    @Override
    public void retryFailures(ExecutableFlow exFlow, String userId) throws ExecutorManagerException {
        this.modifyExecutingJobs(exFlow, "retryFailures", userId, new String[0]);
    }

    @Override
    public void retryExecutingJobs(ExecutableFlow exFlow, String userId, String ... jobIds) throws ExecutorManagerException {
        this.modifyExecutingJobs(exFlow, "retryJobs", userId, jobIds);
    }

    @Override
    public void disableExecutingJobs(ExecutableFlow exFlow, String userId, String ... jobIds) throws ExecutorManagerException {
        this.modifyExecutingJobs(exFlow, "skipJobs", userId, jobIds);
    }

    @Override
    public void enableExecutingJobs(ExecutableFlow exFlow, String userId, String ... jobIds) throws ExecutorManagerException {
        this.modifyExecutingJobs(exFlow, "enableJobs", userId, jobIds);
    }

    @Override
    public void cancelExecutingJobs(ExecutableFlow exFlow, String userId, String ... jobIds) throws ExecutorManagerException {
        this.modifyExecutingJobs(exFlow, "cancelJobs", userId, jobIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> modifyExecutingJobs(ExecutableFlow exFlow, String command, String userId, String ... jobIds) throws ExecutorManagerException {
        ExecutableFlow executableFlow = exFlow;
        synchronized (executableFlow) {
            Pair<ExecutionReference, ExecutableFlow> pair = this.runningFlows.get(exFlow.getExecutionId());
            if (pair == null) {
                throw new ExecutorManagerException("Execution " + exFlow.getExecutionId() + " of flow " + exFlow.getFlowId() + " isn't running.");
            }
            Map<String, Object> response = null;
            if (jobIds != null && jobIds.length > 0) {
                for (String jobId : jobIds) {
                    ExecutableNode node;
                    if (jobId.isEmpty() || (node = exFlow.getExecutableNode(jobId)) != null) continue;
                    throw new ExecutorManagerException("Job " + jobId + " doesn't exist in execution " + exFlow.getExecutionId() + ".");
                }
                String ids = StringUtils.join((Object[])jobIds, (char)',');
                response = this.callExecutorServer(pair.getFirst(), "modifyExecution", userId, new Pair<String, String>("modifyType", command), new Pair<String, String>("jobIds", ids));
            } else {
                response = this.callExecutorServer(pair.getFirst(), "modifyExecution", userId, new Pair<String, String>("modifyType", command));
            }
            return response;
        }
    }

    @Override
    public String submitExecutableFlow(ExecutableFlow exflow, String userId) throws ExecutorManagerException {
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        params.add(new Pair<String, String>("execFlowJson", JSONUtils.toJSON(exflow.toObject())));
        try {
            Map<String, Object> response = this.callRemoteExecutorManager("submitFlow", userId, params);
            if (response.containsKey("error")) {
                throw new ExecutorManagerException((String)response.get("error"));
            }
            String message = (String)response.get("message");
            return message;
        }
        catch (Exception e) {
            throw new ExecutorManagerException(e);
        }
    }

    private Map<String, Object> callExecutorServer(ExecutionReference ref, String action, Pair<String, String> ... params) throws ExecutorManagerException {
        try {
            return this.callExecutorServer(ref.getHost(), ref.getPort(), action, ref.getExecId(), null, params);
        }
        catch (IOException e) {
            throw new ExecutorManagerException(e);
        }
    }

    private Map<String, Object> callExecutorServer(ExecutionReference ref, String action, String user, Pair<String, String> ... params) throws ExecutorManagerException {
        try {
            return this.callExecutorServer(ref.getHost(), ref.getPort(), action, ref.getExecId(), user, params);
        }
        catch (IOException e) {
            throw new ExecutorManagerException(e);
        }
    }

    private Map<String, Object> callExecutorServer(String host, int port, String action, Integer executionId, String user, Pair<String, String> ... params) throws IOException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme("http").setHost(host).setPort(port).setPath("/executor");
        builder.setParameter("action", action);
        if (executionId != null) {
            builder.setParameter("execid", String.valueOf(executionId));
        }
        if (user != null) {
            builder.setParameter("user", user);
        }
        if (params != null) {
            for (Pair<String, String> pair : params) {
                builder.setParameter(pair.getFirst(), pair.getSecond());
            }
        }
        URI uri = null;
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet(uri);
        String response = null;
        try {
            response = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        Map jsonResponse = (Map)JSONUtils.parseJSONFromString(response);
        String error = (String)jsonResponse.get("error");
        if (error != null) {
            throw new IOException(error);
        }
        return jsonResponse;
    }

    @Override
    public Map<String, Object> callExecutorJMX(String hostPort, String action, String mBean) throws IOException {
        URIBuilder builder = new URIBuilder();
        String[] hostPortSplit = hostPort.split(":");
        builder.setScheme("http").setHost(hostPortSplit[0]).setPort(Integer.parseInt(hostPortSplit[1])).setPath("/jmx");
        builder.setParameter(action, "");
        if (mBean != null) {
            builder.setParameter("mBean", mBean);
        }
        URI uri = null;
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet(uri);
        String response = null;
        try {
            response = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        Map jsonResponse = (Map)JSONUtils.parseJSONFromString(response);
        String error = (String)jsonResponse.get("error");
        if (error != null) {
            throw new IOException(error);
        }
        return jsonResponse;
    }

    private Map<String, Object> callRemoteExecutorManager(String action, String user, List<Pair<String, String>> params) throws IOException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme("http").setHost(this.executorManagerHost).setPort(this.executorManagerPort).setPath("executorManager");
        builder.setParameter("action", action);
        if (user != null) {
            builder.setParameter("user", user);
        }
        if (params != null) {
            for (Pair<String, String> pair : params) {
                builder.setParameter(pair.getFirst(), pair.getSecond());
            }
        }
        URI uri = null;
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet(uri);
        String response = null;
        try {
            response = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        Map jsonResponse = (Map)JSONUtils.parseJSONFromString(response);
        String error = (String)jsonResponse.get("error");
        if (error != null) {
            throw new IOException(error);
        }
        return jsonResponse;
    }

    @Override
    public void shutdown() {
        this.updater.shutdown();
    }

    private void evictOldRecentlyFinished(long ageMs) {
        ArrayList recentlyFinishedKeys = new ArrayList(this.recentlyFinished.keySet());
        long oldAgeThreshold = System.currentTimeMillis() - ageMs;
        for (Integer key : recentlyFinishedKeys) {
            ExecutableFlow flow = this.recentlyFinished.get(key);
            if (flow.getEndTime() >= oldAgeThreshold) continue;
            this.recentlyFinished.remove(key);
        }
    }

    private ExecutableFlow updateExecution(Map<String, Object> updateData) throws ExecutorManagerException {
        Integer execId = (Integer)updateData.get("execId");
        if (execId == null) {
            throw new ExecutorManagerException("Response is malformed. Need exec id to update.");
        }
        Pair<ExecutionReference, ExecutableFlow> refPair = this.runningFlows.get(execId);
        if (refPair == null) {
            throw new ExecutorManagerException("No running flow found with the execution id.");
        }
        ExecutionReference ref = refPair.getFirst();
        ExecutableFlow flow = refPair.getSecond();
        if (updateData.containsKey("error")) {
            throw new ExecutorManagerException((String)updateData.get("error"), flow);
        }
        ref.setNextCheckTime(0L);
        ref.setNumErrors(0);
        flow.applyUpdateObject(updateData);
        return flow;
    }

    public boolean isFinished(ExecutableFlow flow) {
        switch (flow.getStatus()) {
            case SUCCEEDED: 
            case FAILED: 
            case KILLED: {
                return true;
            }
        }
        return false;
    }

    private void fillUpdateTimeAndExecId(List<Integer> executionIds, List<Long> updateTimes) {
        for (Pair<ExecutionReference, ExecutableFlow> flow : this.runningFlows.values()) {
            executionIds.add(flow.getSecond().getExecutionId());
            updateTimes.add(flow.getSecond().getUpdateTime());
        }
    }

    @Override
    public int getExecutableFlows(int projectId, String flowId, int from, int length, List<ExecutableFlow> outputList) throws ExecutorManagerException {
        List<ExecutableFlow> flows = this.executorLoader.fetchFlowHistory(projectId, flowId, from, length);
        outputList.addAll(flows);
        return this.executorLoader.fetchNumExecutableFlows(projectId, flowId);
    }

    @Override
    public List<ExecutableFlow> getExecutableFlows(int projectId, String flowId, int from, int length, Status status) throws ExecutorManagerException {
        return this.executorLoader.fetchFlowHistory(projectId, flowId, from, length, status);
    }

    private class UpdaterThread
    extends Thread {
        private boolean shutdown = false;
        private long recentlyFinishedLifetimeMs = 600000L;
        private int waitTimeIdleMs = 2000;
        private int waitTimeMs = 500;

        public UpdaterThread() {
            this.setName("ExecutorManagerRemoteUpdaterThread");
        }

        private void shutdown() {
            this.shutdown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.shutdown) {
                try {
                    ExecutorManagerRemoteAdapter.this.lastThreadCheckTime = System.currentTimeMillis();
                    ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
                    ArrayList<ExecutableFlow> finishedFlows = new ArrayList<ExecutableFlow>();
                    ArrayList updateTimesList = new ArrayList();
                    ArrayList executionIdsList = new ArrayList();
                    ExecutorManagerRemoteAdapter.this.fillUpdateTimeAndExecId(executionIdsList, updateTimesList);
                    params.add(new Pair<String, String>("updateTimeList", JSONUtils.toJSON(updateTimesList)));
                    params.add(new Pair<String, String>("execIdList", JSONUtils.toJSON(executionIdsList)));
                    Map results = null;
                    try {
                        results = ExecutorManagerRemoteAdapter.this.callRemoteExecutorManager("update", "azkaban", params);
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                    if (results != null) {
                        List executionUpdates = (List)results.get("updates");
                        for (Map updateMap : executionUpdates) {
                            try {
                                ExecutableFlow flow = ExecutorManagerRemoteAdapter.this.updateExecution(updateMap);
                                if (!ExecutorManagerRemoteAdapter.this.isFinished(flow)) continue;
                                finishedFlows.add(flow);
                            }
                            catch (ExecutorManagerException e) {
                                logger.error((Object)e);
                            }
                        }
                        ExecutorManagerRemoteAdapter.this.evictOldRecentlyFinished(this.recentlyFinishedLifetimeMs);
                        for (ExecutableFlow flow : finishedFlows) {
                            if (flow.getScheduleId() >= 0 && flow.getStatus() == Status.SUCCEEDED) {
                                ScheduleStatisticManager.invalidateCache(flow.getScheduleId());
                            }
                            ExecutorManagerRemoteAdapter.this.recentlyFinished.put(flow.getExecutionId(), flow);
                        }
                    }
                    UpdaterThread updaterThread = this;
                    synchronized (updaterThread) {
                        try {
                            if (ExecutorManagerRemoteAdapter.this.runningFlows.size() > 0) {
                                this.wait(this.waitTimeMs);
                            } else {
                                this.wait(this.waitTimeIdleMs);
                            }
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
    }
}

