/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.InputStream;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DirectBinaryDecoder;

public class DecoderFactory {
    private static final DecoderFactory DEFAULT_FACTORY = new DefaultDecoderFactory();
    static final int DEFAULT_BUFFER_SIZE = 32000;
    int binaryDecoderBufferSize = 32000;
    boolean preferDirect = false;

    public static DecoderFactory defaultFactory() {
        return DEFAULT_FACTORY;
    }

    public DecoderFactory configureDecoderBufferSize(int size) {
        if (size < 32) {
            size = 32;
        }
        if (size > 0x1000000) {
            size = 0x1000000;
        }
        this.binaryDecoderBufferSize = size;
        return this;
    }

    public int getConfiguredBufferSize() {
        return this.binaryDecoderBufferSize;
    }

    public DecoderFactory configureDirectDecoder(boolean useDirect) {
        this.preferDirect = useDirect;
        return this;
    }

    public BinaryDecoder createBinaryDecoder(InputStream in, BinaryDecoder reuse) {
        if (null == reuse) {
            if (this.preferDirect) {
                return new DirectBinaryDecoder(in);
            }
            return new BinaryDecoder(this.binaryDecoderBufferSize, in);
        }
        if (!this.preferDirect) {
            if (reuse.getClass() == BinaryDecoder.class) {
                reuse.init(this.binaryDecoderBufferSize, in);
                return reuse;
            }
            return new BinaryDecoder(this.binaryDecoderBufferSize, in);
        }
        if (reuse.getClass() == DirectBinaryDecoder.class) {
            ((DirectBinaryDecoder)reuse).init(in);
            return reuse;
        }
        return new DirectBinaryDecoder(in);
    }

    public BinaryDecoder createBinaryDecoder(byte[] bytes, int offset, int length, BinaryDecoder reuse) {
        if (null != reuse && reuse.getClass() == BinaryDecoder.class) {
            reuse.init(bytes, offset, length);
            return reuse;
        }
        return new BinaryDecoder(bytes, offset, length);
    }

    public BinaryDecoder createBinaryDecoder(byte[] bytes, BinaryDecoder reuse) {
        return this.createBinaryDecoder(bytes, 0, bytes.length, reuse);
    }

    private static class DefaultDecoderFactory
    extends DecoderFactory {
        private DefaultDecoderFactory() {
        }

        @Override
        public DecoderFactory configureDecoderBufferSize(int bufferSize) {
            throw new IllegalArgumentException("This Factory instance is Immutable");
        }

        @Override
        public DecoderFactory configureDirectDecoder(boolean arg0) {
            throw new IllegalArgumentException("This Factory instance is Immutable");
        }
    }
}

