/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.nonblockingstore;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import voldemort.VoldemortException;
import voldemort.store.Store;
import voldemort.store.StoreRequest;
import voldemort.store.UnreachableStoreException;
import voldemort.store.nonblockingstore.NonblockingStore;
import voldemort.store.nonblockingstore.NonblockingStoreCallback;
import voldemort.utils.ByteArray;
import voldemort.utils.Utils;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolBasedNonblockingStoreImpl
implements NonblockingStore {
    private final ExecutorService executor;
    private final Store<ByteArray, byte[], byte[]> innerStore;
    private final Logger logger = Logger.getLogger(ThreadPoolBasedNonblockingStoreImpl.class);

    public ThreadPoolBasedNonblockingStoreImpl(ExecutorService executor, Store<ByteArray, byte[], byte[]> innerStore) {
        this.executor = Utils.notNull(executor);
        this.innerStore = Utils.notNull(innerStore);
    }

    @Override
    public void submitGetAllRequest(final Iterable<ByteArray> keys, final Map<ByteArray, byte[]> transforms, NonblockingStoreCallback callback, long timeoutMs) {
        this.submit(new StoreRequest<Map<ByteArray, List<Versioned<byte[]>>>>(){

            @Override
            public Map<ByteArray, List<Versioned<byte[]>>> request(Store<ByteArray, byte[], byte[]> store) {
                return ThreadPoolBasedNonblockingStoreImpl.this.innerStore.getAll(keys, transforms);
            }
        }, callback, timeoutMs, "get all");
    }

    @Override
    public void submitGetRequest(final ByteArray key, final byte[] transforms, NonblockingStoreCallback callback, long timeoutMs) {
        this.submit(new StoreRequest<List<Versioned<byte[]>>>(){

            @Override
            public List<Versioned<byte[]>> request(Store<ByteArray, byte[], byte[]> store) {
                return ThreadPoolBasedNonblockingStoreImpl.this.innerStore.get(key, transforms);
            }
        }, callback, timeoutMs, "get");
    }

    @Override
    public void submitGetVersionsRequest(final ByteArray key, NonblockingStoreCallback callback, long timeoutMs) {
        this.submit(new StoreRequest<List<Version>>(){

            @Override
            public List<Version> request(Store<ByteArray, byte[], byte[]> store) {
                return ThreadPoolBasedNonblockingStoreImpl.this.innerStore.getVersions(key);
            }
        }, callback, timeoutMs, "submit");
    }

    @Override
    public void submitPutRequest(final ByteArray key, final Versioned<byte[]> value, final byte[] transforms, NonblockingStoreCallback callback, long timeoutMs) {
        this.submit(new StoreRequest<Void>(){

            @Override
            public Void request(Store<ByteArray, byte[], byte[]> store) {
                ThreadPoolBasedNonblockingStoreImpl.this.innerStore.put(key, value, transforms);
                return null;
            }
        }, callback, timeoutMs, "put");
    }

    @Override
    public void submitDeleteRequest(final ByteArray key, final Version version, NonblockingStoreCallback callback, long timeoutMs) {
        this.submit(new StoreRequest<Boolean>(){

            @Override
            public Boolean request(Store<ByteArray, byte[], byte[]> store) {
                return ThreadPoolBasedNonblockingStoreImpl.this.innerStore.delete(key, version);
            }
        }, callback, timeoutMs, "delete");
    }

    private void submit(final StoreRequest<?> request, final NonblockingStoreCallback callback, final long timeoutMs, final String operationName) {
        this.executor.submit(new Runnable(){

            public void run() {
                block11: {
                    long start = System.nanoTime();
                    long timeoutNs = timeoutMs * 1000000L;
                    try {
                        Object result = request.request(ThreadPoolBasedNonblockingStoreImpl.this.innerStore);
                        if (callback == null) break block11;
                        long diff = System.nanoTime() - start;
                        if (diff <= timeoutNs) {
                            try {
                                callback.requestComplete(result, diff / 1000000L);
                            }
                            catch (Exception e) {
                                if (ThreadPoolBasedNonblockingStoreImpl.this.logger.isEnabledFor((Priority)Level.WARN)) {
                                    ThreadPoolBasedNonblockingStoreImpl.this.logger.warn((Object)e, (Throwable)e);
                                }
                                break block11;
                            }
                        }
                        UnreachableStoreException ex = new UnreachableStoreException("Failure in " + operationName + ": time out exceeded");
                        try {
                            callback.requestComplete(ex, diff);
                        }
                        catch (Exception e) {
                            if (ThreadPoolBasedNonblockingStoreImpl.this.logger.isEnabledFor((Priority)Level.WARN)) {
                                ThreadPoolBasedNonblockingStoreImpl.this.logger.warn((Object)e, (Throwable)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block11;
                        long diff = System.nanoTime() - start;
                        try {
                            callback.requestComplete(e, diff / 1000000L);
                        }
                        catch (Exception ex) {
                            if (!ThreadPoolBasedNonblockingStoreImpl.this.logger.isEnabledFor((Priority)Level.WARN)) break block11;
                            ThreadPoolBasedNonblockingStoreImpl.this.logger.warn((Object)ex, (Throwable)ex);
                        }
                    }
                }
            }
        });
    }

    @Override
    public void close() throws VoldemortException {
        this.innerStore.close();
    }
}

