/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.cluster.Node;
import voldemort.cluster.Zone;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.routing.RoutingStrategy;
import voldemort.store.routed.GetAllPipelineData;
import voldemort.store.routed.Pipeline;
import voldemort.store.routed.action.AbstractConfigureNodes;
import voldemort.utils.ByteArray;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAllConfigureNodes
extends AbstractConfigureNodes<Iterable<ByteArray>, Map<ByteArray, List<Versioned<byte[]>>>, GetAllPipelineData> {
    private final int preferred;
    private final Iterable<ByteArray> keys;
    private final Zone clientZone;
    private final Map<ByteArray, byte[]> transforms;

    public GetAllConfigureNodes(GetAllPipelineData pipelineData, Pipeline.Event completeEvent, FailureDetector failureDetector, int preferred, int required, RoutingStrategy routingStrategy, Iterable<ByteArray> keys, Map<ByteArray, byte[]> transforms, Zone clientZone) {
        super(pipelineData, completeEvent, failureDetector, required, routingStrategy);
        this.preferred = preferred;
        this.keys = keys;
        this.transforms = transforms;
        this.clientZone = clientZone;
    }

    @Override
    public void execute(Pipeline pipeline) {
        HashMap nodeToKeysMap = Maps.newHashMap();
        HashMap keyToExtraNodesMap = Maps.newHashMap();
        for (ByteArray key : this.keys) {
            List<Node> nodes = null;
            try {
                nodes = this.getNodes(key);
            }
            catch (VoldemortException e) {
                ((GetAllPipelineData)this.pipelineData).setFatalError(e);
                pipeline.addEvent(Pipeline.Event.ERROR);
                return;
            }
            ArrayList preferredNodes = Lists.newArrayListWithCapacity((int)this.preferred);
            ArrayList extraNodes = Lists.newArrayListWithCapacity((int)3);
            if (((GetAllPipelineData)this.pipelineData).getZonesRequired() != null) {
                List zoneNodes;
                int index;
                if (((GetAllPipelineData)this.pipelineData).getZonesRequired() > this.clientZone.getProximityList().size()) {
                    throw new VoldemortException("Number of zones required should be less than the total number of zones");
                }
                if (((GetAllPipelineData)this.pipelineData).getZonesRequired() > this.required) {
                    throw new VoldemortException("Number of zones required should be less than the required number of " + pipeline.getOperation().getSimpleName() + "s");
                }
                HashMap zoneIdToNode = new HashMap();
                for (Node node : nodes) {
                    List<Node> nodesList = null;
                    if (zoneIdToNode.containsKey(node.getZoneId())) {
                        nodesList = (List)zoneIdToNode.get(node.getZoneId());
                    } else {
                        nodesList = new ArrayList();
                        zoneIdToNode.put(node.getZoneId(), nodesList);
                    }
                    nodesList.add(node);
                }
                nodes = new ArrayList<Node>();
                LinkedList<Integer> proximityList = this.clientZone.getProximityList();
                for (index = 0; index < ((GetAllPipelineData)this.pipelineData).getZonesRequired(); ++index) {
                    zoneNodes = (List)zoneIdToNode.get(proximityList.get(index));
                    if (zoneNodes == null) continue;
                    nodes.add((Node)zoneNodes.remove(0));
                }
                nodes.addAll((Collection)zoneIdToNode.get(this.clientZone.getId()));
                for (index = 0; index < proximityList.size(); ++index) {
                    zoneNodes = (List)zoneIdToNode.get(proximityList.get(index));
                    if (zoneNodes == null) continue;
                    nodes.addAll(zoneNodes);
                }
            }
            for (Node node : nodes) {
                if (preferredNodes.size() < this.preferred) {
                    preferredNodes.add(node);
                    continue;
                }
                extraNodes.add(node);
            }
            for (Node node : preferredNodes) {
                List nodeKeys = (List)nodeToKeysMap.get(node);
                if (nodeKeys == null) {
                    nodeKeys = Lists.newArrayList();
                    nodeToKeysMap.put(node, nodeKeys);
                }
                nodeKeys.add(key);
            }
            if (extraNodes.isEmpty()) continue;
            List list = (List)keyToExtraNodesMap.get(key);
            if (list == null) {
                keyToExtraNodesMap.put(key, extraNodes);
                continue;
            }
            list.addAll(extraNodes);
        }
        ((GetAllPipelineData)this.pipelineData).setKeyToExtraNodesMap(keyToExtraNodesMap);
        ((GetAllPipelineData)this.pipelineData).setNodeToKeysMap(nodeToKeysMap);
        ((GetAllPipelineData)this.pipelineData).setTransforms(this.transforms);
        pipeline.addEvent(this.completeEvent);
    }
}

