/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.stats;

import java.util.Arrays;
import org.apache.log4j.Logger;
import voldemort.annotations.concurrency.Threadsafe;

@Threadsafe
public class Histogram {
    private final int nBuckets;
    private final int step;
    private final int[] buckets;
    private final int[] bounds;
    private int size;
    private static final Logger logger = Logger.getLogger(Histogram.class);

    public Histogram(int nBuckets, int step) {
        this.nBuckets = nBuckets;
        this.step = step;
        this.buckets = new int[nBuckets];
        this.bounds = new int[nBuckets];
        this.init();
    }

    protected void init() {
        int bound = 0;
        int i = 0;
        while (i < this.nBuckets) {
            this.bounds[i] = bound;
            ++i;
            bound += this.step;
        }
        this.reset();
    }

    public synchronized void reset() {
        Arrays.fill(this.buckets, 0);
        this.size = 0;
    }

    public synchronized void insert(long data) {
        int index = this.findBucket(data);
        if (index == -1) {
            logger.error((Object)(data + " can't be bucketed, is invalid!"));
            return;
        }
        int n = index;
        this.buckets[n] = this.buckets[n] + 1;
        ++this.size;
    }

    public synchronized int getQuantile(double quantile) {
        int total = 0;
        for (int i = 0; i < this.nBuckets; ++i) {
            double currQuantile = (double)(total += this.buckets[i]) / (double)this.size;
            if (!(currQuantile >= quantile)) continue;
            return this.bounds[i];
        }
        return 0;
    }

    private int findBucket(long needle) {
        long max = this.step * this.nBuckets;
        if (needle > max) {
            return this.nBuckets - 1;
        }
        int low = 0;
        int high = this.nBuckets - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int cmp = this.compareToBucket(mid, needle);
            if (cmp == 0) {
                return mid;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            if (cmp >= 0) continue;
            low = mid + 1;
        }
        return -1;
    }

    private int compareToBucket(int bucket, long needle) {
        int low = this.bounds[bucket];
        int high = low + this.step;
        if ((long)low <= needle && (long)high > needle) {
            return 0;
        }
        if ((long)low > needle) {
            return 1;
        }
        return -1;
    }
}

