/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import voldemort.serialization.SerializationException;
import voldemort.serialization.SerializationUtils;
import voldemort.serialization.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvroReflectiveSerializer<T>
implements Serializer<T> {
    private final Class<T> clazz;

    public AvroReflectiveSerializer(String schemaInfo) {
        try {
            this.clazz = Class.forName(SerializationUtils.getJavaClassFromSchemaInfo(schemaInfo));
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public byte[] toBytes(T object) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        BinaryEncoder encoder = new BinaryEncoder((OutputStream)output);
        ReflectDatumWriter datumWriter = null;
        try {
            try {
                datumWriter = new ReflectDatumWriter(this.clazz);
                datumWriter.write(object, (Encoder)encoder);
                encoder.flush();
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            SerializationUtils.close(output);
            throw throwable;
        }
        SerializationUtils.close(output);
        return output.toByteArray();
    }

    @Override
    public T toObject(byte[] bytes) {
        BinaryDecoder decoder = DecoderFactory.defaultFactory().createBinaryDecoder(bytes, null);
        ReflectDatumReader reader = null;
        try {
            reader = new ReflectDatumReader(this.clazz);
            return (T)reader.read(null, (Decoder)decoder);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }
}

