/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed.action;

import java.util.ArrayList;
import java.util.List;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.routing.RoutingStrategy;
import voldemort.store.InsufficientOperationalNodesException;
import voldemort.store.routed.Pipeline;
import voldemort.store.routed.PipelineData;
import voldemort.store.routed.action.AbstractAction;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigureNodes<K, V, PD extends PipelineData<K, V>>
extends AbstractAction<K, V, PD> {
    protected final FailureDetector failureDetector;
    protected final int required;
    protected final RoutingStrategy routingStrategy;

    protected AbstractConfigureNodes(PD pipelineData, Pipeline.Event completeEvent, FailureDetector failureDetector, int required, RoutingStrategy routingStrategy) {
        super(pipelineData, completeEvent);
        this.failureDetector = failureDetector;
        this.required = required;
        this.routingStrategy = routingStrategy;
    }

    protected List<Node> getNodes(ByteArray key) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.pipelineData.setReplicationSet(this.routingStrategy.routeRequest(key.get()));
        if (this.pipelineData.getReplicationSet().size() == 0) {
            throw new IllegalArgumentException("All servers configured with no partitions");
        }
        for (Node node : this.pipelineData.getReplicationSet()) {
            if (this.failureDetector.isAvailable(node)) {
                nodes.add(node);
                continue;
            }
            this.pipelineData.addFailedNode(node);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Key " + ByteUtils.toHexString(key.get()) + " Node " + node.getId() + " down"));
        }
        if (nodes.size() < this.required) {
            ArrayList<Integer> failedNodes = new ArrayList<Integer>();
            ArrayList<Integer> allNodes = new ArrayList<Integer>();
            for (Node node : this.pipelineData.getReplicationSet()) {
                allNodes.add(node.getId());
            }
            for (Node node : this.pipelineData.getFailedNodes()) {
                failedNodes.add(node.getId());
            }
            String errorMessage = "Only " + nodes.size() + " nodes up in preference list" + ", but " + this.required + " required. Replication set: " + allNodes + "Nodes down: " + failedNodes;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)errorMessage);
            }
            throw new InsufficientOperationalNodesException(errorMessage);
        }
        return nodes;
    }
}

