/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.slop.strategy;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.cluster.Zone;
import voldemort.store.slop.strategy.HintedHandoffStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandoffToAnyStrategy
implements HintedHandoffStrategy {
    private final List<Node> nodes;
    private final Collection<Zone> zones;
    private final boolean enableZoneRouting;
    private final int clientZoneId;

    public HandoffToAnyStrategy(Cluster cluster, boolean enableZoneRouting, int clientZoneId) {
        this.nodes = Lists.newArrayList(cluster.getNodes());
        this.zones = cluster.getZones();
        this.enableZoneRouting = enableZoneRouting;
        this.clientZoneId = clientZoneId;
    }

    @Override
    public List<Node> routeHint(Node origin) {
        ArrayList prefList = Lists.newArrayListWithCapacity((int)this.nodes.size());
        int originZoneId = origin.getZoneId();
        for (Node node : this.nodes) {
            if (node.getId() == origin.getId() || this.enableZoneRouting && this.zones.size() > 1 && (originZoneId == this.clientZoneId ? node.getZoneId() != this.clientZoneId : node.getZoneId() == originZoneId)) continue;
            prefList.add(node);
        }
        Collections.shuffle(prefList);
        return prefList;
    }

    public String toString() {
        return "HandoffToAllStrategy(" + this.nodes + ")";
    }
}

