/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.views;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.serialization.Serializer;
import voldemort.store.StorageEngine;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.store.compress.CompressionStrategy;
import voldemort.store.serialized.SerializingStore;
import voldemort.store.views.View;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.utils.Utils;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewStorageEngine
implements StorageEngine<ByteArray, byte[], byte[]> {
    private final String name;
    private final Store<Object, Object, Object> serializingStore;
    private final StorageEngine<ByteArray, byte[], byte[]> target;
    private final Serializer<Object> valSerializer;
    private final Serializer<Object> transformSerializer;
    private final Serializer<Object> targetKeySerializer;
    private final Serializer<Object> targetValSerializer;
    private final View<Object, Object, Object, Object> view;
    private final CompressionStrategy valueCompressionStrategy;

    public ViewStorageEngine(String name, StorageEngine<ByteArray, byte[], byte[]> target, Serializer<?> valSerializer, Serializer<?> transformSerializer, Serializer<?> targetKeySerializer, Serializer<?> targetValSerializer, CompressionStrategy valueCompressionStrategy, View<?, ?, ?, ?> valueTrans) {
        this.name = name;
        this.target = Utils.notNull(target);
        this.serializingStore = new SerializingStore(target, targetKeySerializer, targetValSerializer, null);
        this.valSerializer = valSerializer;
        this.transformSerializer = transformSerializer;
        this.targetKeySerializer = targetKeySerializer;
        this.targetValSerializer = targetValSerializer;
        this.view = valueTrans;
        this.valueCompressionStrategy = valueCompressionStrategy;
        if (valueTrans == null) {
            throw new IllegalArgumentException("View without either a key transformation or a value transformation.");
        }
    }

    private List<Versioned<byte[]>> inflateValues(List<Versioned<byte[]>> result) {
        ArrayList<Versioned<byte[]>> inflated = new ArrayList<Versioned<byte[]>>(result.size());
        for (Versioned<byte[]> item : result) {
            inflated.add(this.inflateValue(item));
        }
        return inflated;
    }

    private List<Versioned<byte[]>> deflateValues(List<Versioned<byte[]>> values) {
        ArrayList<Versioned<byte[]>> deflated = new ArrayList<Versioned<byte[]>>(values.size());
        for (Versioned<byte[]> item : values) {
            deflated.add(this.deflateValue(item));
        }
        return deflated;
    }

    private Versioned<byte[]> deflateValue(Versioned<byte[]> versioned) throws VoldemortException {
        byte[] deflatedData = null;
        try {
            deflatedData = this.valueCompressionStrategy.deflate(versioned.getValue());
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
        return new Versioned<byte[]>(deflatedData, versioned.getVersion());
    }

    private Versioned<byte[]> inflateValue(Versioned<byte[]> versioned) throws VoldemortException {
        byte[] inflatedData = null;
        try {
            inflatedData = this.valueCompressionStrategy.inflate(versioned.getValue());
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
        return new Versioned<byte[]>(inflatedData, versioned.getVersion());
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        return this.target.delete(key, version);
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key, byte[] transforms) throws VoldemortException {
        List<Versioned<byte[]>> values = this.target.get(key, null);
        List<Versioned<byte[]>> results = new ArrayList<Versioned<byte[]>>();
        if (this.valueCompressionStrategy != null) {
            values = this.inflateValues(values);
        }
        for (Versioned versioned : values) {
            results.add(new Versioned<byte[]>(this.valueToViewSchema(key, (byte[])versioned.getValue(), transforms), versioned.getVersion()));
        }
        if (this.valueCompressionStrategy != null) {
            results = this.deflateValues(results);
        }
        return results;
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys, Map<ByteArray, byte[]> transforms) throws VoldemortException {
        return StoreUtils.getAll(this, keys, transforms);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Version> getVersions(ByteArray key) {
        return this.target.getVersions(key);
    }

    @Override
    public void put(ByteArray key, Versioned<byte[]> value, byte[] transforms) throws VoldemortException {
        if (this.valueCompressionStrategy != null) {
            value = this.inflateValue(value);
        }
        Versioned<byte[]> result = Versioned.value(this.valueFromViewSchema(key, value.getValue(), transforms), value.getVersion());
        if (this.valueCompressionStrategy != null) {
            result = this.deflateValue(result);
        }
        this.target.put(key, result, null);
    }

    @Override
    public ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> entries() {
        return new ViewIterator(this.target.entries());
    }

    @Override
    public ClosableIterator<ByteArray> keys() {
        return StoreUtils.keys(this.entries());
    }

    @Override
    public void truncate() {
        ViewIterator iterator = new ViewIterator(this.target.entries());
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            this.target.delete((ByteArray)pair.getFirst(), ((Versioned)pair.getSecond()).getVersion());
        }
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        if (capability == StoreCapabilityType.VIEW_TARGET) {
            return this.target;
        }
        return null;
    }

    @Override
    public void close() throws VoldemortException {
    }

    private byte[] valueFromViewSchema(ByteArray key, byte[] value, byte[] transforms) {
        return this.targetValSerializer.toBytes(this.view.viewToStore(this.serializingStore, this.targetKeySerializer.toObject(key.get()), this.valSerializer.toObject(value), this.transformSerializer != null && transforms != null ? this.transformSerializer.toObject(transforms) : null));
    }

    private byte[] valueToViewSchema(ByteArray key, byte[] value, byte[] transforms) {
        return this.valSerializer.toBytes(this.view.storeToView(this.serializingStore, this.targetKeySerializer.toObject(key.get()), this.targetValSerializer.toObject(value), this.transformSerializer != null && transforms != null ? this.transformSerializer.toObject(transforms) : null));
    }

    @Override
    public boolean isPartitionAware() {
        return this.target.isPartitionAware();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ViewIterator
    extends AbstractIterator<Pair<ByteArray, Versioned<byte[]>>>
    implements ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> {
        private final ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> inner;

        public ViewIterator(ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> inner) {
            this.inner = inner;
        }

        @Override
        public void close() {
            this.inner.close();
        }

        protected Pair<ByteArray, Versioned<byte[]>> computeNext() {
            Pair p = (Pair)this.inner.next();
            Versioned<byte[]> newVal = Versioned.value(ViewStorageEngine.this.valueToViewSchema((ByteArray)p.getFirst(), (byte[])((Versioned)p.getSecond()).getValue(), null), ((Versioned)p.getSecond()).getVersion());
            return Pair.create(p.getFirst(), newVal);
        }
    }
}

