/*
 * Decompiled with CFR 0.152.
 */
package voldemort.xml;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMSource;
import org.xml.sax.SAXException;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.cluster.Zone;
import voldemort.utils.Utils;
import voldemort.xml.MappingException;

public class ClusterMapper {
    private static final String SERVER_ID_ELMT = "id";
    private static final String SERVER_PARTITIONS_ELMT = "partitions";
    private static final String ZONE_ELMT = "zone";
    private static final String ZONE_ID_ELMT = "zone-id";
    private static final String ZONE_PROXIMITY_LIST_ELMT = "proximity-list";
    private static final String SERVER_ELMT = "server";
    private static final String CLUSTER_NAME_ELMT = "name";
    private static final String CLUSTER_ELMT = "cluster";
    private static final String HOST_ELMT = "host";
    private static final String HTTP_PORT_ELMT = "http-port";
    private static final String SOCKET_PORT_ELMT = "socket-port";
    private static final String ADMIN_PORT_ELMT = "admin-port";
    private final Schema schema;

    public ClusterMapper() {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource source = new StreamSource(ClusterMapper.class.getResourceAsStream("cluster.xsd"));
            this.schema = factory.newSchema(source);
        }
        catch (SAXException e) {
            throw new MappingException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cluster readCluster(File f) throws IOException {
        FileReader reader = null;
        try {
            reader = new FileReader(f);
            Cluster cluster = this.readCluster(reader);
            return cluster;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public Cluster readCluster(Reader input) {
        return this.readCluster(input, true);
    }

    public Cluster readCluster(Reader input, boolean verifySchema) {
        try {
            Element root;
            SAXBuilder builder = new SAXBuilder(false);
            Document doc = builder.build(input);
            if (verifySchema) {
                Validator validator = this.schema.newValidator();
                validator.validate((Source)new JDOMSource(doc));
            }
            if (!(root = doc.getRootElement()).getName().equals(CLUSTER_ELMT)) {
                throw new MappingException("Invalid root element: " + doc.getRootElement().getName());
            }
            String name = root.getChildText(CLUSTER_NAME_ELMT);
            ArrayList<Zone> zones = new ArrayList<Zone>();
            for (Element node : root.getChildren(ZONE_ELMT)) {
                zones.add(this.readZone(node));
            }
            ArrayList<Node> servers = new ArrayList<Node>();
            for (Element node : root.getChildren(SERVER_ELMT)) {
                servers.add(this.readServer(node));
            }
            return new Cluster(name, servers, zones);
        }
        catch (JDOMException e) {
            throw new MappingException(e);
        }
        catch (SAXException e) {
            throw new MappingException(e);
        }
        catch (IOException e) {
            throw new MappingException(e);
        }
    }

    private Zone readZone(Element zone) {
        int zoneId = Integer.parseInt(zone.getChildText(ZONE_ID_ELMT));
        String proximityListTest = zone.getChildText(ZONE_PROXIMITY_LIST_ELMT).trim();
        LinkedList<Integer> proximityList = new LinkedList<Integer>();
        for (String node : Utils.COMMA_SEP.split(proximityListTest)) {
            if (node.trim().length() <= 0) continue;
            proximityList.add(Integer.parseInt(node.trim()));
        }
        return new Zone(zoneId, proximityList);
    }

    public Node readServer(Element server) {
        int id = Integer.parseInt(server.getChildText(SERVER_ID_ELMT));
        String host = server.getChildText(HOST_ELMT);
        int httpPort = Integer.parseInt(server.getChildText(HTTP_PORT_ELMT));
        int socketPort = Integer.parseInt(server.getChildText(SOCKET_PORT_ELMT));
        int adminPort = null != server.getChildText(ADMIN_PORT_ELMT) ? Integer.parseInt(server.getChildText(ADMIN_PORT_ELMT)) : -1;
        int zoneId = null != server.getChildText(ZONE_ID_ELMT) ? Integer.parseInt(server.getChildText(ZONE_ID_ELMT)) : 0;
        String partitionsText = server.getChildText(SERVER_PARTITIONS_ELMT).trim();
        ArrayList<Integer> partitions = new ArrayList<Integer>();
        for (String aPartition : Utils.COMMA_SEP.split(partitionsText)) {
            if (aPartition.trim().length() <= 0) continue;
            partitions.add(Integer.parseInt(aPartition.trim()));
        }
        return new Node(id, host, httpPort, socketPort, adminPort, zoneId, partitions);
    }

    public String writeCluster(Cluster cluster) {
        boolean displayZones;
        Document doc = new Document(new Element(CLUSTER_ELMT));
        doc.getRootElement().addContent((Content)new Element(CLUSTER_NAME_ELMT).setText(cluster.getName()));
        boolean bl = displayZones = cluster.getZones().size() > 1;
        if (displayZones) {
            for (Zone zone : cluster.getZones()) {
                doc.getRootElement().addContent((Content)this.mapZone(zone));
            }
        }
        for (Node node : cluster.getNodes()) {
            doc.getRootElement().addContent((Content)this.mapServer(node, displayZones));
        }
        XMLOutputter serializer = new XMLOutputter(Format.getPrettyFormat());
        return serializer.outputString(doc.getRootElement());
    }

    private Element mapZone(Zone zone) {
        Element zoneElement = new Element(ZONE_ELMT);
        zoneElement.addContent((Content)new Element(ZONE_ID_ELMT).setText(Integer.toString(zone.getId())));
        String proximityListTest = StringUtils.join((Object[])zone.getProximityList().toArray(), (String)", ");
        zoneElement.addContent((Content)new Element(ZONE_PROXIMITY_LIST_ELMT).setText(proximityListTest));
        return zoneElement;
    }

    private Element mapServer(Node node, boolean displayZones) {
        Element server = new Element(SERVER_ELMT);
        server.addContent((Content)new Element(SERVER_ID_ELMT).setText(Integer.toString(node.getId())));
        server.addContent((Content)new Element(HOST_ELMT).setText(node.getHost()));
        server.addContent((Content)new Element(HTTP_PORT_ELMT).setText(Integer.toString(node.getHttpPort())));
        server.addContent((Content)new Element(SOCKET_PORT_ELMT).setText(Integer.toString(node.getSocketPort())));
        server.addContent((Content)new Element(ADMIN_PORT_ELMT).setText(Integer.toString(node.getAdminPort())));
        String serverPartitionsText = StringUtils.join((Object[])node.getPartitionIds().toArray(), (String)", ");
        server.addContent((Content)new Element(SERVER_PARTITIONS_ELMT).setText(serverPartitionsText));
        if (displayZones) {
            server.addContent((Content)new Element(ZONE_ID_ELMT).setText(Integer.toString(node.getZoneId())));
        }
        return server;
    }
}

