/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger;

import azkaban.execapp.event.EventHandler;
import azkaban.execapp.event.EventListener;
import azkaban.executor.ExecutorManager;
import azkaban.trigger.ActionTypeLoader;
import azkaban.trigger.CheckerTypeLoader;
import azkaban.trigger.Condition;
import azkaban.trigger.ConditionChecker;
import azkaban.trigger.Trigger;
import azkaban.trigger.TriggerAction;
import azkaban.trigger.TriggerLoader;
import azkaban.trigger.TriggerLoaderException;
import azkaban.trigger.TriggerManager;
import azkaban.trigger.TriggerManagerAdapter;
import azkaban.trigger.TriggerManagerException;
import azkaban.trigger.TriggerStatus;
import azkaban.utils.Props;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class TriggerManager
extends EventHandler
implements TriggerManagerAdapter {
    private static Logger logger = Logger.getLogger(TriggerManager.class);
    public static final long DEFAULT_SCANNER_INTERVAL_MS = 60000L;
    private static Map<Integer, Trigger> triggerIdMap = new ConcurrentHashMap();
    private CheckerTypeLoader checkerTypeLoader;
    private ActionTypeLoader actionTypeLoader;
    private TriggerLoader triggerLoader;
    private final TriggerScannerThread runnerThread;
    private long lastRunnerThreadCheckTime = -1L;
    private long runnerThreadIdleTime = -1L;
    private LocalTriggerJMX jmxStats = new LocalTriggerJMX(this, null);
    private ExecutorManagerEventListener listener = new ExecutorManagerEventListener(this);
    private final Object syncObj = new Object();
    private String scannerStage = "";

    public TriggerManager(Props props, TriggerLoader triggerLoader, ExecutorManager executorManager) throws TriggerManagerException {
        this.triggerLoader = triggerLoader;
        long scannerInterval = props.getLong("trigger.scan.interval", 60000L);
        this.runnerThread = new TriggerScannerThread(this, scannerInterval);
        this.checkerTypeLoader = new CheckerTypeLoader();
        this.actionTypeLoader = new ActionTypeLoader();
        try {
            this.checkerTypeLoader.init(props);
            this.actionTypeLoader.init(props);
        }
        catch (Exception e) {
            throw new TriggerManagerException((Throwable)e);
        }
        Condition.setCheckerLoader((CheckerTypeLoader)this.checkerTypeLoader);
        Trigger.setActionTypeLoader((ActionTypeLoader)this.actionTypeLoader);
        executorManager.addListener((EventListener)this.listener);
        logger.info((Object)"TriggerManager loaded.");
    }

    public void start() throws TriggerManagerException {
        try {
            List triggers = this.triggerLoader.loadTriggers();
            for (Trigger t : triggers) {
                this.runnerThread.addTrigger(t);
                triggerIdMap.put(t.getTriggerId(), t);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TriggerManagerException((Throwable)e);
        }
        this.runnerThread.start();
    }

    protected CheckerTypeLoader getCheckerLoader() {
        return this.checkerTypeLoader;
    }

    protected ActionTypeLoader getActionLoader() {
        return this.actionTypeLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTrigger(Trigger t) throws TriggerManagerException {
        Object object = this.syncObj;
        synchronized (object) {
            try {
                this.triggerLoader.addTrigger(t);
            }
            catch (TriggerLoaderException e) {
                throw new TriggerManagerException((Throwable)e);
            }
            this.runnerThread.addTrigger(t);
            triggerIdMap.put(t.getTriggerId(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrigger(int id) throws TriggerManagerException {
        Object object = this.syncObj;
        synchronized (object) {
            Trigger t = (Trigger)triggerIdMap.get(id);
            if (t != null) {
                this.removeTrigger((Trigger)triggerIdMap.get(id));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTrigger(int id) throws TriggerManagerException {
        Object object = this.syncObj;
        synchronized (object) {
            Trigger t;
            if (!triggerIdMap.containsKey(id)) {
                throw new TriggerManagerException("The trigger to update " + id + " doesn't exist!");
            }
            try {
                t = this.triggerLoader.loadTrigger(id);
            }
            catch (TriggerLoaderException e) {
                throw new TriggerManagerException((Throwable)e);
            }
            this.updateTrigger(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTrigger(Trigger t) throws TriggerManagerException {
        Object object = this.syncObj;
        synchronized (object) {
            this.runnerThread.deleteTrigger((Trigger)triggerIdMap.get(t.getTriggerId()));
            this.runnerThread.addTrigger(t);
            triggerIdMap.put(t.getTriggerId(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrigger(Trigger t) throws TriggerManagerException {
        Object object = this.syncObj;
        synchronized (object) {
            this.runnerThread.deleteTrigger(t);
            triggerIdMap.remove(t.getTriggerId());
            try {
                t.stopCheckers();
                this.triggerLoader.removeTrigger(t);
            }
            catch (TriggerLoaderException e) {
                throw new TriggerManagerException((Throwable)e);
            }
        }
    }

    public List<Trigger> getTriggers() {
        return new ArrayList<Trigger>(triggerIdMap.values());
    }

    public Map<String, Class<? extends ConditionChecker>> getSupportedCheckers() {
        return this.checkerTypeLoader.getSupportedCheckers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger getTrigger(int triggerId) {
        Object object = this.syncObj;
        synchronized (object) {
            return (Trigger)triggerIdMap.get(triggerId);
        }
    }

    public void expireTrigger(int triggerId) {
        Trigger t = this.getTrigger(triggerId);
        t.setStatus(TriggerStatus.EXPIRED);
    }

    public List<Trigger> getTriggers(String triggerSource) {
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        for (Trigger t : triggerIdMap.values()) {
            if (!t.getSource().equals(triggerSource)) continue;
            triggers.add(t);
        }
        return triggers;
    }

    public List<Trigger> getTriggerUpdates(String triggerSource, long lastUpdateTime) throws TriggerManagerException {
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        for (Trigger t : triggerIdMap.values()) {
            if (!t.getSource().equals(triggerSource) || t.getLastModifyTime() <= lastUpdateTime) continue;
            triggers.add(t);
        }
        return triggers;
    }

    public List<Trigger> getAllTriggerUpdates(long lastUpdateTime) throws TriggerManagerException {
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        for (Trigger t : triggerIdMap.values()) {
            if (t.getLastModifyTime() <= lastUpdateTime) continue;
            triggers.add(t);
        }
        return triggers;
    }

    public void insertTrigger(Trigger t, String user) throws TriggerManagerException {
        this.insertTrigger(t);
    }

    public void removeTrigger(int id, String user) throws TriggerManagerException {
        this.removeTrigger(id);
    }

    public void updateTrigger(Trigger t, String user) throws TriggerManagerException {
        this.updateTrigger(t);
    }

    public void shutdown() {
        this.runnerThread.shutdown();
    }

    public TriggerManagerAdapter.TriggerJMX getJMX() {
        return this.jmxStats;
    }

    public void registerCheckerType(String name, Class<? extends ConditionChecker> checker) {
        this.checkerTypeLoader.registerCheckerType(name, checker);
    }

    public void registerActionType(String name, Class<? extends TriggerAction> action) {
        this.actionTypeLoader.registerActionType(name, action);
    }

    static /* synthetic */ Logger access$0() {
        return logger;
    }

    static /* synthetic */ Object access$1(TriggerManager triggerManager) {
        return triggerManager.syncObj;
    }

    static /* synthetic */ void access$2(TriggerManager triggerManager, long l) {
        triggerManager.lastRunnerThreadCheckTime = l;
    }

    static /* synthetic */ long access$3(TriggerManager triggerManager) {
        return triggerManager.lastRunnerThreadCheckTime;
    }

    static /* synthetic */ void access$4(TriggerManager triggerManager, String string) {
        triggerManager.scannerStage = string;
    }

    static /* synthetic */ void access$5(TriggerManager triggerManager, long l) {
        triggerManager.runnerThreadIdleTime = l;
    }

    static /* synthetic */ long access$6(TriggerManager triggerManager) {
        return triggerManager.runnerThreadIdleTime;
    }

    static /* synthetic */ TriggerLoader access$7(TriggerManager triggerManager) {
        return triggerManager.triggerLoader;
    }

    static /* synthetic */ TriggerScannerThread access$8(TriggerManager triggerManager) {
        return triggerManager.runnerThread;
    }

    static /* synthetic */ Map access$9() {
        return triggerIdMap;
    }

    static /* synthetic */ String access$10(TriggerManager triggerManager) {
        return triggerManager.scannerStage;
    }
}

