/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.cmdline;

import java.text.ParseException;
import java.util.HashMap;

public class CmdLineParser {
    public static final char EndOfOpts = '-';
    private String[] mArgs;
    private HashMap<Character, ValueExpected> mShort;
    private HashMap<String, Character> mLong;
    private int mArgNum;
    private String mVal;

    public CmdLineParser(String[] args) {
        this.mArgs = args;
        this.mArgNum = 0;
        this.mShort = new HashMap();
        this.mLong = new HashMap();
    }

    public void registerOpt(char c, String s, ValueExpected ve) {
        if (c == '-') {
            throw new AssertionError((Object)"CmdLineParser:  '-' is not a legal single character designator.");
        }
        Character cc = Character.valueOf(c);
        if (this.mShort.put(cc, ve) != null) {
            throw new AssertionError((Object)("CmdLineParser:  You have already registered option " + cc.toString()));
        }
        if (this.mLong != null && this.mLong.put(s, cc) != null) {
            throw new AssertionError((Object)("CmdLineParser:  You have already registered option " + s));
        }
    }

    public char getNextOpt() throws ParseException {
        if (this.mArgNum >= this.mArgs.length) {
            return '-';
        }
        int offset = 1;
        this.mVal = null;
        try {
            char i;
            String arg = this.mArgs[this.mArgNum];
            if (arg.charAt(0) != '-') {
                --this.mArgNum;
                char c = '-';
                return c;
            }
            for (i = '\u0001'; i < arg.length() && arg.charAt(i) == '-'; ++i) {
                ++offset;
            }
            if (offset == arg.length()) {
                i = '-';
                return i;
            }
            Character cc = null;
            if (arg.substring(offset).length() == 1) {
                cc = Character.valueOf(arg.substring(offset).charAt(0));
            } else {
                cc = this.mLong.get(arg.substring(offset));
                if (cc == null) {
                    Integer ii = this.mArgNum + 1;
                    String errMsg = "Found unknown option (" + arg + ") at position " + ii.toString();
                    throw new ParseException(errMsg, this.mArgNum);
                }
            }
            ValueExpected ve = this.mShort.get(cc);
            if (ve == null) {
                Integer ii = this.mArgNum + 1;
                String errMsg = "Found unknown option (" + arg + ") at position " + ii.toString();
                throw new ParseException(errMsg, this.mArgNum);
            }
            switch (ve) {
                case NOT_ACCEPTED: {
                    char ii = cc.charValue();
                    return ii;
                }
                case REQUIRED: {
                    if (this.mArgNum + 1 >= this.mArgs.length || this.mArgs[this.mArgNum + 1].charAt(0) == '-') {
                        String errMsg = "Option " + arg + " requires a value but you did not provide one.";
                        throw new ParseException(errMsg, this.mArgNum);
                    }
                    this.mVal = this.mArgs[++this.mArgNum];
                    char c = cc.charValue();
                    return c;
                }
                case OPTIONAL: {
                    if (this.mArgNum + 1 < this.mArgs.length && this.mArgs[this.mArgNum + 1].charAt(0) != '-') {
                        this.mVal = this.mArgs[++this.mArgNum];
                    }
                    char c = cc.charValue();
                    return c;
                }
            }
            throw new AssertionError((Object)"Unknown valueExpected state");
        }
        finally {
            ++this.mArgNum;
        }
    }

    public String[] getRemainingArgs() {
        if (this.mArgNum == this.mArgs.length) {
            return null;
        }
        String[] remainders = new String[this.mArgs.length - this.mArgNum];
        System.arraycopy(this.mArgs, this.mArgNum, remainders, 0, remainders.length);
        return remainders;
    }

    public String getValStr() {
        return this.mVal;
    }

    public Integer getValInt() throws NumberFormatException {
        if (this.mVal == null) {
            return null;
        }
        return new Integer(this.mVal);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValueExpected {
        REQUIRED,
        OPTIONAL,
        NOT_ACCEPTED;

    }
}

