/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.optimizer.Rule;
import org.apache.pig.newplan.optimizer.Transformer;

public class LimitOptimizer
extends Rule {
    public LimitOptimizer(String name) {
        super(name, false);
    }

    protected OperatorPlan buildPattern() {
        LogicalPlan plan = new LogicalPlan();
        LOLimit limit = new LOLimit(plan, 0L);
        plan.add(limit);
        return plan;
    }

    public Transformer getNewTransformer() {
        return new OptimizeLimitTransformer();
    }

    public class OptimizeLimitTransformer
    extends Transformer {
        public boolean check(OperatorPlan matched) {
            LOLimit limit = (LOLimit)matched.getSources().get(0);
            List<Operator> preds = LimitOptimizer.this.currentPlan.getPredecessors(limit);
            if (preds == null || preds.size() == 0) {
                return false;
            }
            Operator pred = preds.get(0);
            if (pred instanceof LOCogroup || pred instanceof LOFilter || pred instanceof LOLoad || pred instanceof LOSplit || pred instanceof LODistinct || pred instanceof LOJoin) {
                return false;
            }
            if (pred instanceof LOForEach) {
                LOForEach foreach = (LOForEach)pred;
                LogicalPlan innerPlan = foreach.getInnerPlan();
                Iterator<Operator> it = innerPlan.getOperators();
                while (it.hasNext()) {
                    LOGenerate gen;
                    boolean[] flattenFlags;
                    Operator op = it.next();
                    if (!(op instanceof LOGenerate) || (flattenFlags = (gen = (LOGenerate)op).getFlattenFlags()) == null) continue;
                    for (boolean flatten : flattenFlags) {
                        if (!flatten) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        public OperatorPlan reportChanges() {
            return LimitOptimizer.this.currentPlan;
        }

        public void transform(OperatorPlan matched) throws FrontendException {
            List<Operator> greatGrandparants;
            List<Operator> grandparants;
            LOLimit limit = (LOLimit)matched.getSources().get(0);
            List<Operator> preds = LimitOptimizer.this.currentPlan.getPredecessors(limit);
            Operator pred = preds.get(0);
            if (pred instanceof LOForEach) {
                Operator prepredecessor = LimitOptimizer.this.currentPlan.getPredecessors(pred).get(0);
                LimitOptimizer.this.currentPlan.removeAndReconnect(limit);
                LimitOptimizer.this.currentPlan.insertBetween(prepredecessor, limit, pred);
            } else if (pred instanceof LOCross || pred instanceof LOUnion) {
                LOLimit newLimit = null;
                ArrayList<Operator> nodesToProcess = new ArrayList<Operator>();
                for (Operator prepredecessor : LimitOptimizer.this.currentPlan.getPredecessors(pred)) {
                    nodesToProcess.add(prepredecessor);
                }
                for (Operator prepredecessor : nodesToProcess) {
                    if (prepredecessor instanceof LOLimit) {
                        LOLimit l;
                        l.setLimit((l = (LOLimit)prepredecessor).getLimit() < limit.getLimit() ? l.getLimit() : limit.getLimit());
                        continue;
                    }
                    newLimit = new LOLimit((LogicalPlan)LimitOptimizer.this.currentPlan, limit.getLimit());
                    LimitOptimizer.this.currentPlan.insertBetween(prepredecessor, newLimit, pred);
                }
            } else if (pred instanceof LOSort) {
                LOSort sort = (LOSort)pred;
                if (sort.getLimit() == -1L) {
                    sort.setLimit(limit.getLimit());
                } else {
                    sort.setLimit(sort.getLimit() < limit.getLimit() ? sort.getLimit() : limit.getLimit());
                }
                LimitOptimizer.this.currentPlan.removeAndReconnect(limit);
            } else if (pred instanceof LOLimit) {
                LOLimit beforeLimit;
                beforeLimit.setLimit((beforeLimit = (LOLimit)pred).getLimit() < limit.getLimit() ? beforeLimit.getLimit() : limit.getLimit());
                LimitOptimizer.this.currentPlan.removeAndReconnect(limit);
            } else if (pred instanceof LOSplitOutput && (grandparants = LimitOptimizer.this.currentPlan.getPredecessors(pred)) != null && grandparants.size() != 0 && grandparants.get(0) instanceof LOSplit && (greatGrandparants = LimitOptimizer.this.currentPlan.getPredecessors(grandparants.get(0))) != null && greatGrandparants.size() != 0 && greatGrandparants.get(0) instanceof LOSort) {
                LOSort sort = (LOSort)greatGrandparants.get(0);
                LOSort newSort = new LOSort(sort.getPlan(), sort.getSortColPlans(), sort.getAscendingCols(), sort.getUserFunc());
                newSort.setLimit(limit.getLimit());
                LimitOptimizer.this.currentPlan.replace(limit, newSort);
            }
        }
    }
}

