/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.user;

import azkaban.user.Permission;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PermissionTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testEmptyPermissionCreation() throws Exception {
        Permission permission = new Permission();
        permission.addPermissionsByName(new String[0]);
    }

    @Test
    public void testSinglePermissionCreation() throws Exception {
        Permission perm1 = new Permission();
        perm1.addPermissionsByName(new String[]{"READ"});
        Permission perm2 = new Permission();
        perm2.addPermission(new Permission.Type[]{Permission.Type.READ});
        this.info("Compare " + perm1.toString() + " and " + perm2.toString());
        Assert.assertTrue((boolean)perm1.equals((Object)perm2));
    }

    @Test
    public void testListPermissionCreation() throws Exception {
        Permission perm1 = new Permission();
        perm1.addPermissionsByName(new String[]{"READ", "EXECUTE"});
        Permission perm2 = new Permission();
        perm2.addPermission(new Permission.Type[]{Permission.Type.EXECUTE, Permission.Type.READ});
        this.info("Compare " + perm1.toString() + " and " + perm2.toString());
        Assert.assertTrue((boolean)perm1.equals((Object)perm2));
    }

    @Test
    public void testRemovePermission() throws Exception {
        Permission perm1 = new Permission();
        perm1.addPermissionsByName(new String[]{"READ", "EXECUTE", "WRITE"});
        perm1.removePermissions(new Permission.Type[]{Permission.Type.EXECUTE});
        Permission perm2 = new Permission();
        perm2.addPermission(new Permission.Type[]{Permission.Type.READ, Permission.Type.WRITE});
        this.info("Compare " + perm1.toString() + " and " + perm2.toString());
        Assert.assertTrue((boolean)perm1.equals((Object)perm2));
    }

    @Test
    public void testRemovePermissionByName() throws Exception {
        Permission perm1 = new Permission();
        perm1.addPermissionsByName(new String[]{"READ", "EXECUTE", "WRITE"});
        perm1.removePermissionsByName(new String[]{"EXECUTE"});
        Permission perm2 = new Permission();
        perm2.addPermission(new Permission.Type[]{Permission.Type.READ, Permission.Type.WRITE});
        this.info("Compare " + perm1.toString() + " and " + perm2.toString());
        Assert.assertTrue((boolean)perm1.equals((Object)perm2));
    }

    @Test
    public void testToAndFromObject() throws Exception {
        Permission permission = new Permission();
        permission.addPermissionsByName(new String[]{"READ", "EXECUTE", "WRITE"});
        String[] array = permission.toStringArray();
        Permission permission2 = new Permission();
        permission2.addPermissionsByName(array);
        Assert.assertTrue((boolean)permission.equals((Object)permission2));
    }

    @Test
    public void testFlags() throws Exception {
        Permission permission = new Permission();
        permission.addPermission(new Permission.Type[]{Permission.Type.READ, Permission.Type.WRITE});
        int flags = permission.toFlags();
        Permission permission2 = new Permission(flags);
        Assert.assertTrue((boolean)permission2.isPermissionSet(Permission.Type.READ));
        Assert.assertTrue((boolean)permission2.isPermissionSet(Permission.Type.WRITE));
        Assert.assertTrue((boolean)permission.equals((Object)permission2));
    }

    public void info(String message) {
        System.out.println(message);
    }
}

