/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization.protobuf;

import com.google.protobuf.Message;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import voldemort.serialization.SerializationUtils;
import voldemort.serialization.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtoBufSerializer<T extends Message>
implements Serializer<T> {
    private final Method parseFromMethod;
    private final Class<T> messageClass;

    public ProtoBufSerializer(String currentSchemaInfo) {
        try {
            this.messageClass = Class.forName(SerializationUtils.getJavaClassFromSchemaInfo(currentSchemaInfo), false, Thread.currentThread().getContextClassLoader());
            if (!Message.class.isAssignableFrom(this.messageClass)) {
                throw new IllegalArgumentException("Class provided should be a subtype of Message");
            }
            this.parseFromMethod = this.messageClass.getMethod("parseFrom", byte[].class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No parseFrom static method found, the provided class is not a Message.", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public byte[] toBytes(T object) {
        return object.toByteArray();
    }

    @Override
    public T toObject(byte[] bytes) {
        try {
            return (T)((Message)this.messageClass.cast(this.parseFromMethod.invoke(null, new Object[]{bytes})));
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

