/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.storage;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.client.ClientThreadPool;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.cluster.failuredetector.FailureDetectorConfig;
import voldemort.cluster.failuredetector.FailureDetectorListener;
import voldemort.cluster.failuredetector.FailureDetectorUtils;
import voldemort.cluster.failuredetector.ServerStoreVerifier;
import voldemort.routing.RoutingStrategy;
import voldemort.routing.RoutingStrategyFactory;
import voldemort.server.AbstractService;
import voldemort.server.RequestRoutingType;
import voldemort.server.ServiceType;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortConfig;
import voldemort.server.scheduler.DataCleanupJob;
import voldemort.server.scheduler.SchedulerService;
import voldemort.server.scheduler.slop.BlockingSlopPusherJob;
import voldemort.server.scheduler.slop.StreamingSlopPusherJob;
import voldemort.server.storage.RepairJob;
import voldemort.server.storage.ScanPermitWrapper;
import voldemort.store.StorageConfiguration;
import voldemort.store.StorageEngine;
import voldemort.store.Store;
import voldemort.store.StoreDefinition;
import voldemort.store.invalidmetadata.InvalidMetadataCheckingStore;
import voldemort.store.logging.LoggingStore;
import voldemort.store.metadata.MetadataStore;
import voldemort.store.metadata.MetadataStoreListener;
import voldemort.store.nonblockingstore.NonblockingStore;
import voldemort.store.readonly.ReadOnlyStorageConfiguration;
import voldemort.store.readonly.ReadOnlyStorageEngine;
import voldemort.store.rebalancing.RebootstrappingStore;
import voldemort.store.rebalancing.RedirectingStore;
import voldemort.store.routed.RoutedStore;
import voldemort.store.routed.RoutedStoreFactory;
import voldemort.store.slop.SlopStorageEngine;
import voldemort.store.socket.SocketStoreFactory;
import voldemort.store.socket.clientrequest.ClientRequestExecutorPool;
import voldemort.store.stats.DataSetStats;
import voldemort.store.stats.StatTrackingStore;
import voldemort.store.stats.StoreStats;
import voldemort.store.stats.StoreStatsJmx;
import voldemort.store.versioned.InconsistencyResolvingStore;
import voldemort.store.views.ViewStorageConfiguration;
import voldemort.store.views.ViewStorageEngine;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.ConfigurationException;
import voldemort.utils.DynamicThrottleLimit;
import voldemort.utils.EventThrottler;
import voldemort.utils.JmxUtils;
import voldemort.utils.Pair;
import voldemort.utils.ReflectUtils;
import voldemort.utils.SystemTime;
import voldemort.versioning.VectorClock;
import voldemort.versioning.VectorClockInconsistencyResolver;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JmxManaged(description="Start and stop all stores.")
public class StorageService
extends AbstractService {
    private static final Logger logger = Logger.getLogger((String)StorageService.class.getName());
    private final VoldemortConfig voldemortConfig;
    private final StoreRepository storeRepository;
    private final SchedulerService scheduler;
    private final MetadataStore metadata;
    private final DynamicThrottleLimit dynThrottleLimit;
    private final ScanPermitWrapper scanPermitWrapper;
    private final SocketStoreFactory storeFactory;
    private final ConcurrentMap<String, StorageConfiguration> storageConfigs;
    private final ClientThreadPool clientThreadPool;
    private final FailureDetector failureDetector;
    private final StoreStats storeStats;
    private final RoutedStoreFactory routedStoreFactory;

    public StorageService(StoreRepository storeRepository, MetadataStore metadata, SchedulerService scheduler, VoldemortConfig config) {
        super(ServiceType.STORAGE);
        this.voldemortConfig = config;
        this.scheduler = scheduler;
        this.storeRepository = storeRepository;
        this.metadata = metadata;
        this.scanPermitWrapper = new ScanPermitWrapper(this.voldemortConfig.getNumScanPermits());
        this.storageConfigs = new ConcurrentHashMap<String, StorageConfiguration>();
        this.clientThreadPool = new ClientThreadPool(config.getClientMaxThreads(), config.getClientThreadIdleMs(), config.getClientMaxQueuedRequests());
        this.storeFactory = new ClientRequestExecutorPool(config.getClientSelectors(), config.getClientMaxConnectionsPerNode(), config.getClientConnectionTimeoutMs(), config.getSocketTimeoutMs(), config.getSocketBufferSize(), config.getSocketKeepAlive());
        FailureDetectorConfig failureDetectorConfig = new FailureDetectorConfig(this.voldemortConfig).setNodes(metadata.getCluster().getNodes()).setStoreVerifier(new ServerStoreVerifier(this.storeFactory, metadata, config));
        this.failureDetector = FailureDetectorUtils.create(failureDetectorConfig, config.isJmxEnabled(), new FailureDetectorListener[0]);
        this.storeStats = new StoreStats();
        this.routedStoreFactory = new RoutedStoreFactory(this.voldemortConfig.isPipelineRoutedStoreEnabled(), this.clientThreadPool, this.voldemortConfig.getTimeoutConfig());
        if (this.voldemortConfig.getStorageConfigurations().contains(ReadOnlyStorageConfiguration.class.getName())) {
            long rate = this.voldemortConfig.getMaxBytesPerSecond();
            this.dynThrottleLimit = new DynamicThrottleLimit(rate);
        } else {
            this.dynThrottleLimit = null;
        }
    }

    private void initStorageConfig(String configClassName) {
        try {
            Class<?> configClass = ReflectUtils.loadClass(configClassName);
            StorageConfiguration configuration = (StorageConfiguration)ReflectUtils.callConstructor(configClass, new Class[]{VoldemortConfig.class}, new Object[]{this.voldemortConfig});
            logger.info((Object)("Initializing " + configuration.getType() + " storage engine."));
            this.storageConfigs.put(configuration.getType(), configuration);
            if (this.voldemortConfig.isJmxEnabled()) {
                JmxUtils.registerMbean(configuration.getType() + "StorageConfiguration", configuration);
            }
        }
        catch (IllegalStateException e) {
            logger.error((Object)("Error loading storage configuration '" + configClassName + "'."), (Throwable)e);
        }
        if (this.storageConfigs.size() == 0) {
            throw new ConfigurationException("No storage engine has been enabled!");
        }
    }

    @Override
    protected void startInner() {
        this.registerEngine(this.metadata, false, "metadata");
        for (String configClassName : this.voldemortConfig.getStorageConfigurations()) {
            this.initStorageConfig(configClassName);
        }
        this.storageConfigs.put("view", new ViewStorageConfiguration(this.voldemortConfig, this.metadata.getStoreDefList(), this.storeRepository));
        if (this.voldemortConfig.isSlopEnabled()) {
            logger.info((Object)("Initializing the slop store using " + this.voldemortConfig.getSlopStoreType()));
            StorageConfiguration config = (StorageConfiguration)this.storageConfigs.get(this.voldemortConfig.getSlopStoreType());
            if (config == null) {
                throw new ConfigurationException("Attempt to open store slop but " + this.voldemortConfig.getSlopStoreType() + " storage engine has not been enabled.");
            }
            StoreDefinition slopStoreDefinition = new StoreDefinition("slop", null, null, null, null, null, null, null, 0, null, 0, null, 0, null, null, null, null, null, null, null, null, null, null, null, 0L);
            SlopStorageEngine slopEngine = new SlopStorageEngine(config.getStore(slopStoreDefinition), this.metadata.getCluster());
            this.registerEngine(slopEngine, false, "slop");
            this.storeRepository.setSlopStore(slopEngine);
            if (this.voldemortConfig.isSlopPusherJobEnabled()) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.add(13, (int)(this.voldemortConfig.getSlopFrequencyMs() / 1000L));
                Date nextRun = cal.getTime();
                logger.info((Object)("Initializing slop pusher job type " + this.voldemortConfig.getPusherType() + " at " + nextRun));
                this.scheduler.schedule("slop", this.voldemortConfig.getPusherType().compareTo("blocking") == 0 ? new BlockingSlopPusherJob(this.storeRepository, this.metadata, this.failureDetector, this.voldemortConfig, this.scanPermitWrapper) : new StreamingSlopPusherJob(this.storeRepository, this.metadata, this.failureDetector, this.voldemortConfig, this.scanPermitWrapper), nextRun, this.voldemortConfig.getSlopFrequencyMs());
            }
            if (this.voldemortConfig.isRepairEnabled()) {
                logger.info((Object)"Initializing repair job.");
                RepairJob job = new RepairJob(this.storeRepository, this.metadata, this.scanPermitWrapper);
                JmxUtils.registerMbean(job, JmxUtils.createObjectName(job.getClass()));
                this.storeRepository.registerRepairJob(job);
            }
        }
        ArrayList<StoreDefinition> storeDefs = new ArrayList<StoreDefinition>(this.metadata.getStoreDefList());
        logger.info((Object)"Initializing stores:");
        for (StoreDefinition def : storeDefs) {
            if (def.isView()) continue;
            this.openStore(def);
        }
        for (StoreDefinition def : storeDefs) {
            if (!def.isView()) continue;
            this.openStore(def);
        }
        if (this.voldemortConfig.isStatTrackingEnabled()) {
            if (this.voldemortConfig.isEnableJmxClusterName()) {
                JmxUtils.registerMbean(new StoreStatsJmx(this.storeStats), JmxUtils.createObjectName(this.metadata.getCluster().getName() + ".voldemort.store.stats.aggregate", "aggregate-perf"));
            } else {
                JmxUtils.registerMbean(new StoreStatsJmx(this.storeStats), JmxUtils.createObjectName("voldemort.store.stats.aggregate", "aggregate-perf"));
            }
        }
        logger.info((Object)"All stores initialized.");
    }

    public void updateStore(StoreDefinition storeDef) {
        logger.info((Object)("Updating store '" + storeDef.getName() + "' (" + storeDef.getType() + ")."));
        StorageConfiguration config = (StorageConfiguration)this.storageConfigs.get(storeDef.getType());
        if (config == null) {
            throw new ConfigurationException("Attempt to open store " + storeDef.getName() + " but " + storeDef.getType() + " storage engine has not been enabled.");
        }
        config.update(storeDef);
    }

    public void openStore(StoreDefinition storeDef) {
        boolean isReadOnly;
        logger.info((Object)("Opening store '" + storeDef.getName() + "' (" + storeDef.getType() + ")."));
        StorageConfiguration config = (StorageConfiguration)this.storageConfigs.get(storeDef.getType());
        if (config == null) {
            throw new ConfigurationException("Attempt to open store " + storeDef.getName() + " but " + storeDef.getType() + " storage engine has not been enabled.");
        }
        boolean bl = isReadOnly = storeDef.getType().compareTo("read-only") == 0;
        if (isReadOnly) {
            RoutingStrategy routingStrategy = new RoutingStrategyFactory().updateRoutingStrategy(storeDef, this.metadata.getCluster());
            ((ReadOnlyStorageConfiguration)config).setRoutingStrategy(routingStrategy);
        }
        final StorageEngine<ByteArray, byte[], byte[]> engine = config.getStore(storeDef);
        if (storeDef.getType().compareTo("read-only") == 0) {
            this.metadata.addMetadataStoreListener(storeDef.getName(), new MetadataStoreListener(){

                public void updateRoutingStrategy(RoutingStrategy updatedRoutingStrategy) {
                    ((ReadOnlyStorageEngine)engine).setRoutingStrategy(updatedRoutingStrategy);
                }
            });
        }
        try {
            this.registerEngine(engine, isReadOnly, storeDef.getType());
            if (this.voldemortConfig.isServerRoutingEnabled()) {
                this.registerNodeStores(storeDef, this.metadata.getCluster(), this.voldemortConfig.getNodeId());
            }
            if (storeDef.hasRetentionPeriod()) {
                this.scheduleCleanupJob(storeDef, engine);
            }
        }
        catch (Exception e) {
            this.unregisterEngine(engine, isReadOnly, storeDef.getType());
            throw new VoldemortException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEngine(StorageEngine<ByteArray, byte[], byte[]> engine, boolean isReadOnly, String storeType) {
        boolean isMetadata;
        String storeName = engine.getName();
        Store<ByteArray, byte[], byte[]> store = this.storeRepository.removeLocalStore(storeName);
        boolean isSlop = storeType.compareTo("slop") == 0;
        boolean isView = storeType.compareTo("view") == 0;
        boolean bl = isMetadata = storeName.compareTo("metadata") == 0;
        if (store != null) {
            if (this.voldemortConfig.isJmxEnabled()) {
                MBeanServer mBeanServer;
                ObjectName name;
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (!(isSlop || !this.voldemortConfig.isEnableRebalanceService() || isReadOnly || isMetadata || isView)) {
                    name = null;
                    name = this.voldemortConfig.isEnableJmxClusterName() ? JmxUtils.createObjectName(this.metadata.getCluster().getName() + "." + JmxUtils.getPackageName(RedirectingStore.class), store.getName()) : JmxUtils.createObjectName(JmxUtils.getPackageName(RedirectingStore.class), store.getName());
                    mBeanServer = mbeanServer;
                    synchronized (mBeanServer) {
                        if (mbeanServer.isRegistered(name)) {
                            JmxUtils.unregisterMbean(mbeanServer, name);
                        }
                    }
                }
                if (this.voldemortConfig.isStatTrackingEnabled()) {
                    name = null;
                    name = this.voldemortConfig.isEnableJmxClusterName() ? JmxUtils.createObjectName(this.metadata.getCluster().getName() + "." + JmxUtils.getPackageName(store.getClass()), store.getName()) : JmxUtils.createObjectName(JmxUtils.getPackageName(store.getClass()), store.getName());
                    mBeanServer = mbeanServer;
                    synchronized (mBeanServer) {
                        if (mbeanServer.isRegistered(name)) {
                            JmxUtils.unregisterMbean(mbeanServer, name);
                        }
                    }
                }
            }
            if (this.voldemortConfig.isServerRoutingEnabled() && !isSlop) {
                this.storeRepository.removeRoutedStore(storeName);
                for (Node node : this.metadata.getCluster().getNodes()) {
                    this.storeRepository.removeNodeStore(storeName, node.getId());
                }
            }
        }
        this.storeRepository.removeStorageEngine(storeName);
        if (!isView) {
            engine.truncate();
        }
        engine.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEngine(StorageEngine<ByteArray, byte[], byte[]> engine, boolean isReadOnly, String storeType) {
        boolean isView;
        Cluster cluster = this.metadata.getCluster();
        this.storeRepository.addStorageEngine(engine);
        Store<ByteArray, Object, Object> store = engine;
        boolean isMetadata = store.getName().compareTo("metadata") == 0;
        boolean isSlop = storeType.compareTo("slop") == 0;
        boolean bl = isView = storeType.compareTo("view") == 0;
        if (this.voldemortConfig.isVerboseLoggingEnabled()) {
            store = new LoggingStore<ByteArray, byte[], byte[]>(store, cluster.getName(), SystemTime.INSTANCE);
        }
        if (!isSlop) {
            if (this.voldemortConfig.isEnableRebalanceService() && !isReadOnly && !isMetadata && !isView) {
                store = new RedirectingStore(store, this.metadata, this.storeRepository, this.failureDetector, this.storeFactory);
                if (this.voldemortConfig.isJmxEnabled()) {
                    MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                    ObjectName name = null;
                    name = this.voldemortConfig.isEnableJmxClusterName() ? JmxUtils.createObjectName(cluster.getName() + "." + JmxUtils.getPackageName(RedirectingStore.class), store.getName()) : JmxUtils.createObjectName(JmxUtils.getPackageName(RedirectingStore.class), store.getName());
                    MBeanServer mBeanServer = mbeanServer;
                    synchronized (mBeanServer) {
                        if (mbeanServer.isRegistered(name)) {
                            JmxUtils.unregisterMbean(mbeanServer, name);
                        }
                        JmxUtils.registerMbean(mbeanServer, JmxUtils.createModelMBean(store), name);
                    }
                }
            }
            if (this.voldemortConfig.isMetadataCheckingEnabled() && !isMetadata) {
                store = new InvalidMetadataCheckingStore(this.metadata.getNodeId(), store, this.metadata);
            }
        }
        if (this.voldemortConfig.isStatTrackingEnabled()) {
            StatTrackingStore statStore = new StatTrackingStore(store, this.storeStats);
            store = statStore;
            if (this.voldemortConfig.isJmxEnabled()) {
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                ObjectName name = null;
                name = this.voldemortConfig.isEnableJmxClusterName() ? JmxUtils.createObjectName(this.metadata.getCluster().getName() + "." + JmxUtils.getPackageName(store.getClass()), store.getName()) : JmxUtils.createObjectName(JmxUtils.getPackageName(store.getClass()), store.getName());
                MBeanServer mBeanServer = mbeanServer;
                synchronized (mBeanServer) {
                    if (mbeanServer.isRegistered(name)) {
                        JmxUtils.unregisterMbean(mbeanServer, name);
                    }
                    JmxUtils.registerMbean(mbeanServer, JmxUtils.createModelMBean(new StoreStatsJmx(statStore.getStats())), name);
                }
            }
        }
        this.storeRepository.addLocalStore(store);
    }

    public void registerNodeStores(StoreDefinition def, Cluster cluster, int localNode) {
        HashMap<Integer, Store<ByteArray, byte[], byte[]>> nodeStores = new HashMap<Integer, Store<ByteArray, byte[], byte[]>>(cluster.getNumberOfNodes());
        HashMap<Integer, NonblockingStore> nonblockingStores = new HashMap<Integer, NonblockingStore>(cluster.getNumberOfNodes());
        try {
            for (Node node : cluster.getNodes()) {
                Store<ByteArray, byte[], byte[]> store = this.getNodeStore(def.getName(), node, localNode);
                this.storeRepository.addNodeStore(node.getId(), store);
                nodeStores.put(node.getId(), store);
                NonblockingStore nonblockingStore = this.routedStoreFactory.toNonblockingStore(store);
                nonblockingStores.put(node.getId(), nonblockingStore);
            }
            Store<ByteArray, byte[], byte[]> store = this.routedStoreFactory.create(cluster, def, nodeStores, nonblockingStores, null, null, true, cluster.getNodeById(localNode).getZoneId(), this.failureDetector);
            store = new RebootstrappingStore(this.metadata, this.storeRepository, this.voldemortConfig, (RoutedStore)store, this.storeFactory);
            store = new InconsistencyResolvingStore<ByteArray, byte[], byte[]>(store, new VectorClockInconsistencyResolver());
            this.storeRepository.addRoutedStore(store);
        }
        catch (Exception e) {
            for (Node node : cluster.getNodes()) {
                this.storeRepository.removeNodeStore(def.getName(), node.getId());
            }
            throw new VoldemortException(e);
        }
    }

    private Store<ByteArray, byte[], byte[]> getNodeStore(String storeName, Node node, int localNode) {
        Store<ByteArray, byte[], byte[]> store = node.getId() == localNode ? this.storeRepository.getLocalStore(storeName) : this.createNodeStore(storeName, node);
        return store;
    }

    private Store<ByteArray, byte[], byte[]> createNodeStore(String storeName, Node node) {
        return this.storeFactory.create(storeName, node.getHost(), node.getSocketPort(), this.voldemortConfig.getRequestFormatType(), RequestRoutingType.NORMAL);
    }

    private void scheduleCleanupJob(StoreDefinition storeDef, StorageEngine<ByteArray, byte[], byte[]> engine) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.add(6, 1);
        cal.set(11, this.voldemortConfig.getRetentionCleanupFirstStartTimeInHour());
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date startTime = cal.getTime();
        int maxReadRate = storeDef.hasRetentionScanThrottleRate() ? storeDef.getRetentionScanThrottleRate() : Integer.MAX_VALUE;
        logger.info((Object)("Scheduling data retention cleanup job for store '" + storeDef.getName() + "' at " + startTime + " with retention scan throttle rate:" + maxReadRate + " Entries/second."));
        EventThrottler throttler = new EventThrottler(maxReadRate);
        DataCleanupJob<ByteArray, byte[], byte[]> cleanupJob = new DataCleanupJob<ByteArray, byte[], byte[]>(engine, this.scanPermitWrapper, (long)storeDef.getRetentionDays().intValue() * 86400000L, SystemTime.INSTANCE, throttler);
        if (this.voldemortConfig.isJmxEnabled()) {
            JmxUtils.registerMbean("DataCleanupJob-" + engine.getName(), cleanupJob);
        }
        this.scheduler.schedule("cleanup-" + storeDef.getName(), cleanupJob, startTime, (long)this.voldemortConfig.getRetentionCleanupScheduledPeriodInHour() * 3600000L);
    }

    @Override
    protected void stopInner() {
        Exception lastException = null;
        logger.info((Object)"Closing all stores.");
        for (Store<ByteArray, byte[], byte[]> store : this.storeRepository.getAllRoutedStores()) {
            logger.info((Object)("Closing routed store for " + store.getName()));
            try {
                store.close();
            }
            catch (Exception e) {
                logger.error((Object)e);
                lastException = e;
            }
        }
        for (StorageEngine storageEngine : this.storeRepository.getAllStorageEngines()) {
            logger.info((Object)("Closing storage engine for " + storageEngine.getName()));
            try {
                storageEngine.close();
            }
            catch (Exception e) {
                logger.error((Object)e);
                lastException = e;
            }
        }
        logger.info((Object)"All stores closed.");
        if (this.storeRepository.hasSlopStore()) {
            try {
                this.storeRepository.getSlopStore().close();
            }
            catch (Exception e) {
                logger.error((Object)e);
                lastException = e;
            }
        }
        logger.info((Object)"Closing storage configurations.");
        for (StorageConfiguration storageConfiguration : this.storageConfigs.values()) {
            logger.info((Object)("Closing " + storageConfiguration.getType() + " storage config."));
            try {
                storageConfiguration.close();
            }
            catch (Exception e) {
                logger.error((Object)e);
                lastException = e;
            }
        }
        this.clientThreadPool.shutdown();
        try {
            if (!this.clientThreadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.clientThreadPool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.clientThreadPool.shutdownNow();
        }
        logger.info((Object)"Closed client threadpool.");
        if (this.failureDetector != null) {
            try {
                this.failureDetector.destroy();
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        logger.info((Object)"Closed failure detector.");
        if (lastException instanceof VoldemortException) {
            throw (VoldemortException)lastException;
        }
        if (lastException != null) {
            throw new VoldemortException(lastException);
        }
    }

    public MetadataStore getMetadataStore() {
        return this.metadata;
    }

    public StoreRepository getStoreRepository() {
        return this.storeRepository;
    }

    @JmxOperation(description="Force cleanup of old data based on retention policy, allows override of throttle-rate", impact=1)
    public void forceCleanupOldData(String storeName) {
        StoreDefinition storeDef = this.getMetadataStore().getStoreDef(storeName);
        int throttleRate = storeDef.hasRetentionScanThrottleRate() ? storeDef.getRetentionScanThrottleRate() : Integer.MAX_VALUE;
        this.forceCleanupOldDataThrottled(storeName, throttleRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxOperation(description="Force cleanup of old data based on retention policy.", impact=1)
    public void forceCleanupOldDataThrottled(String storeName, int entryScanThrottleRate) {
        block7: {
            logger.info((Object)("forceCleanupOldData() called for store " + storeName + " with retention scan throttle rate:" + entryScanThrottleRate + " Entries/second."));
            try {
                StoreDefinition storeDef = this.getMetadataStore().getStoreDef(storeName);
                StorageEngine<ByteArray, byte[], byte[]> engine = this.storeRepository.getStorageEngine(storeName);
                if (null == engine) break block7;
                if (storeDef.hasRetentionPeriod()) {
                    ExecutorService executor = Executors.newFixedThreadPool(1);
                    try {
                        if (this.scanPermitWrapper.availablePermits() >= 1) {
                            executor.execute(new DataCleanupJob<ByteArray, byte[], byte[]>(engine, this.scanPermitWrapper, (long)storeDef.getRetentionDays().intValue() * 86400000L, SystemTime.INSTANCE, new EventThrottler(entryScanThrottleRate)));
                        } else {
                            logger.error((Object)("forceCleanupOldData() No permit available to run cleanJob already running multiple instance." + engine.getName()));
                        }
                        Object var7_7 = null;
                        executor.shutdown();
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        executor.shutdown();
                        throw throwable;
                    }
                }
                logger.error((Object)("forceCleanupOldData() No retention policy found for " + storeName));
            }
            catch (Exception e) {
                logger.error((Object)"Error while running forceCleanupOldData()", (Throwable)e);
                throw new VoldemortException(e);
            }
        }
    }

    @JmxOperation(description="Print stats on a given store", impact=1)
    public void logStoreStats(final String storeName) {
        this.scheduler.scheduleNow(new Runnable(){

            public void run() {
                StorageEngine<ByteArray, byte[], byte[]> store = StorageService.this.storeRepository.getStorageEngine(storeName);
                if (store == null) {
                    logger.error((Object)("Invalid store name '" + storeName + "'."));
                    return;
                }
                logger.info((Object)("Data statistics for store '" + store.getName() + "':\n\n" + StorageService.this.calculateStats(store) + "\n\n"));
            }
        });
    }

    @JmxOperation(description="Print stats on a given store", impact=1)
    public void logStoreStats() {
        this.scheduler.scheduleNow(new Runnable(){

            public void run() {
                try {
                    DataSetStats totals = new DataSetStats();
                    ArrayList<String> names = new ArrayList<String>();
                    ArrayList<DataSetStats> stats = new ArrayList<DataSetStats>();
                    for (StorageEngine<ByteArray, byte[], byte[]> store : StorageService.this.storeRepository.getAllStorageEngines()) {
                        if (store instanceof ReadOnlyStorageEngine || store instanceof ViewStorageEngine || store instanceof MetadataStore) continue;
                        logger.info(store.getClass());
                        logger.info((Object)("Calculating stats for '" + store.getName() + "'..."));
                        DataSetStats curr = StorageService.this.calculateStats(store);
                        names.add(store.getName());
                        stats.add(curr);
                        totals.add(curr);
                    }
                    for (int i = 0; i < names.size(); ++i) {
                        logger.info((Object)("\n\nData statistics for store '" + (String)names.get(i) + "':\n" + stats.get(i) + "\n\n"));
                    }
                    logger.info((Object)("Totals: \n " + totals + "\n\n"));
                }
                catch (Exception e) {
                    logger.error((Object)"Error in thread: ", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSetStats calculateStats(StorageEngine<ByteArray, byte[], byte[]> store) {
        DataSetStats stats = new DataSetStats();
        ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> iter = store.entries();
        try {
            int count = 0;
            while (iter.hasNext()) {
                Pair pair = (Pair)iter.next();
                VectorClock clock = (VectorClock)((Versioned)pair.getSecond()).getVersion();
                stats.countEntry(((ByteArray)pair.getFirst()).length(), ((byte[])((Versioned)pair.getSecond()).getValue()).length + clock.sizeInBytes());
                if (count % 10000 == 0) {
                    logger.debug((Object)("Processing key " + count));
                }
                ++count;
            }
            Object var8_7 = null;
            iter.close();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            iter.close();
            throw throwable;
        }
        return stats;
    }

    public SocketStoreFactory getSocketStoreFactory() {
        return this.storeFactory;
    }

    public DynamicThrottleLimit getDynThrottleLimit() {
        return this.dynThrottleLimit;
    }

    @JmxGetter(name="getScanPermitOwners", description="Returns class names of services holding the scan permit")
    public List<String> getPermitOwners() {
        return this.scanPermitWrapper.getPermitOwners();
    }

    @JmxGetter(name="numGrantedScanPermits", description="Returns number of scan permits granted at the moment")
    public long getGrantedPermits() {
        return this.scanPermitWrapper.getGrantedPermits();
    }

    @JmxGetter(name="numEntriesScanned", description="Returns number of entries scanned since last call")
    public long getEntriesScanned() {
        return this.scanPermitWrapper.getEntriesScanned();
    }
}

