/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.client.protocol.RequestFormatType;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.server.AbstractService;
import voldemort.server.ServiceType;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortConfig;
import voldemort.server.VoldemortService;
import voldemort.server.gossip.GossipService;
import voldemort.server.http.HttpService;
import voldemort.server.jmx.JmxService;
import voldemort.server.niosocket.NioSocketService;
import voldemort.server.protocol.SocketRequestHandlerFactory;
import voldemort.server.protocol.admin.AsyncOperationService;
import voldemort.server.rebalance.Rebalancer;
import voldemort.server.rebalance.RebalancerService;
import voldemort.server.scheduler.SchedulerService;
import voldemort.server.socket.SocketService;
import voldemort.server.storage.StorageService;
import voldemort.store.configuration.ConfigurationStorageEngine;
import voldemort.store.metadata.MetadataStore;
import voldemort.utils.JNAUtils;
import voldemort.utils.RebalanceUtils;
import voldemort.utils.SystemTime;
import voldemort.utils.Utils;
import voldemort.versioning.Versioned;
import voldemort.xml.ClusterMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoldemortServer
extends AbstractService {
    private static final Logger logger = Logger.getLogger((String)VoldemortServer.class.getName());
    public static final long DEFAULT_PUSHER_POLL_MS = 60000L;
    private static final int ASYNC_REQUEST_CACHE_SIZE = 64;
    private final Node identityNode;
    private final List<VoldemortService> services;
    private final StoreRepository storeRepository;
    private final VoldemortConfig voldemortConfig;
    private final MetadataStore metadata;
    private AsyncOperationService asyncService;

    public VoldemortServer(VoldemortConfig config) {
        super(ServiceType.VOLDEMORT);
        this.voldemortConfig = config;
        this.storeRepository = new StoreRepository();
        this.metadata = MetadataStore.readFromDirectory(new File(this.voldemortConfig.getMetadataDirectory()), this.voldemortConfig.getNodeId());
        this.identityNode = this.metadata.getCluster().getNodeById(this.voldemortConfig.getNodeId());
        this.checkHostName();
        this.services = this.createServices();
    }

    public VoldemortServer(VoldemortConfig config, Cluster cluster) {
        super(ServiceType.VOLDEMORT);
        this.voldemortConfig = config;
        this.identityNode = cluster.getNodeById(this.voldemortConfig.getNodeId());
        this.checkHostName();
        this.storeRepository = new StoreRepository();
        ConfigurationStorageEngine metadataInnerEngine = new ConfigurationStorageEngine("metadata-config-store", this.voldemortConfig.getMetadataDirectory());
        metadataInnerEngine.put("cluster.xml", new Versioned<String>(new ClusterMapper().writeCluster(cluster)), null);
        this.metadata = new MetadataStore(metadataInnerEngine, this.voldemortConfig.getNodeId());
        this.services = this.createServices();
    }

    public AsyncOperationService getAsyncRunner() {
        return this.asyncService;
    }

    private void checkHostName() {
        try {
            HashSet<String> ipAddrList = new HashSet<String>();
            InetAddress localhost = InetAddress.getLocalHost();
            InetAddress[] serverAddrs = InetAddress.getAllByName(localhost.getCanonicalHostName());
            ipAddrList.add("localhost");
            if (serverAddrs != null && serverAddrs.length > 0) {
                for (InetAddress addr : serverAddrs) {
                    if (addr.getHostName() != null) {
                        ipAddrList.add(addr.getHostName());
                    }
                    if (addr.getHostAddress() != null) {
                        ipAddrList.add(addr.getHostAddress());
                    }
                    if (addr.getCanonicalHostName() == null) continue;
                    ipAddrList.add(addr.getCanonicalHostName());
                }
            }
            if (!ipAddrList.contains(this.identityNode.getHost())) {
                logger.info((Object)("List of all IPs & Hostnames for the current node:" + ipAddrList));
                logger.info((Object)("Configured hostname [" + this.identityNode.getHost() + "] does not seem to match current node."));
            }
        }
        catch (UnknownHostException uhe) {
            logger.warn((Object)"Unable to obtain IP information for current node", (Throwable)uhe);
        }
        catch (SecurityException se) {
            logger.warn((Object)"Security Manager does not permit obtaining IP Information", (Throwable)se);
        }
    }

    private List<VoldemortService> createServices() {
        ArrayList<VoldemortService> services = new ArrayList<VoldemortService>();
        SchedulerService scheduler = new SchedulerService(this.voldemortConfig.getSchedulerThreads(), SystemTime.INSTANCE, this.voldemortConfig.canInterruptService());
        StorageService storageService = new StorageService(this.storeRepository, this.metadata, scheduler, this.voldemortConfig);
        this.asyncService = new AsyncOperationService(scheduler, 64);
        services.add(storageService);
        services.add(scheduler);
        services.add(this.asyncService);
        if (this.voldemortConfig.isHttpServerEnabled()) {
            services.add(new HttpService(this, storageService, this.storeRepository, RequestFormatType.VOLDEMORT_V1, this.voldemortConfig.getMaxThreads(), this.identityNode.getHttpPort()));
        }
        if (this.voldemortConfig.isSocketServerEnabled()) {
            SocketRequestHandlerFactory socketRequestHandlerFactory = new SocketRequestHandlerFactory(storageService, this.storeRepository, this.metadata, this.voldemortConfig, this.asyncService, null);
            if (this.voldemortConfig.getUseNioConnector()) {
                logger.info((Object)"Using NIO Connector.");
                services.add(new NioSocketService(socketRequestHandlerFactory, this.identityNode.getSocketPort(), this.voldemortConfig.getSocketBufferSize(), this.voldemortConfig.getNioConnectorSelectors(), "nio-socket-server", this.voldemortConfig.isJmxEnabled()));
            } else {
                logger.info((Object)"Using BIO Connector.");
                services.add(new SocketService(socketRequestHandlerFactory, this.identityNode.getSocketPort(), this.voldemortConfig.getCoreThreads(), this.voldemortConfig.getMaxThreads(), this.voldemortConfig.getSocketBufferSize(), "socket-server", this.voldemortConfig.isJmxEnabled()));
            }
        }
        if (this.voldemortConfig.isAdminServerEnabled()) {
            Rebalancer rebalancer = null;
            if (this.voldemortConfig.isEnableRebalanceService()) {
                RebalancerService rebalancerService = new RebalancerService(this.storeRepository, this.metadata, this.voldemortConfig, this.asyncService, scheduler);
                services.add(rebalancerService);
                rebalancer = rebalancerService.getRebalancer();
            }
            SocketRequestHandlerFactory adminRequestHandlerFactory = new SocketRequestHandlerFactory(storageService, this.storeRepository, this.metadata, this.voldemortConfig, this.asyncService, rebalancer);
            if (this.voldemortConfig.getUseNioConnector()) {
                logger.info((Object)"Using NIO Connector for Admin Service.");
                services.add(new NioSocketService(adminRequestHandlerFactory, this.identityNode.getAdminPort(), this.voldemortConfig.getAdminSocketBufferSize(), this.voldemortConfig.getNioAdminConnectorSelectors(), "admin-server", this.voldemortConfig.isJmxEnabled()));
            } else {
                logger.info((Object)"Using BIO Connector for Admin Service.");
                services.add(new SocketService(adminRequestHandlerFactory, this.identityNode.getAdminPort(), this.voldemortConfig.getAdminCoreThreads(), this.voldemortConfig.getAdminMaxThreads(), this.voldemortConfig.getAdminSocketBufferSize(), "admin-server", this.voldemortConfig.isJmxEnabled()));
            }
        }
        if (this.voldemortConfig.isGossipEnabled()) {
            services.add(new GossipService(this.metadata, scheduler, this.voldemortConfig));
        }
        if (this.voldemortConfig.isJmxEnabled()) {
            services.add(new JmxService(this, this.metadata.getCluster(), this.storeRepository, services));
        }
        return ImmutableList.copyOf(services);
    }

    @Override
    protected void startInner() throws VoldemortException {
        JNAUtils.tryMlockall();
        logger.info((Object)("Starting " + this.services.size() + " services."));
        long start = System.currentTimeMillis();
        for (VoldemortService service : this.services) {
            service.start();
        }
        long end = System.currentTimeMillis();
        logger.info((Object)("Startup completed in " + (end - start) + " ms."));
    }

    @Override
    protected void stopInner() throws VoldemortException {
        ArrayList<VoldemortException> exceptions = new ArrayList<VoldemortException>();
        logger.info((Object)("Stopping services:" + this.getIdentityNode().getId()));
        for (VoldemortService service : Utils.reversed(this.services)) {
            try {
                service.stop();
            }
            catch (VoldemortException e) {
                exceptions.add(e);
                logger.error((Object)e);
            }
        }
        logger.info((Object)("All services stopped for Node:" + this.getIdentityNode().getId()));
        if (exceptions.size() > 0) {
            throw (VoldemortException)exceptions.get(0);
        }
        JNAUtils.tryMunlockall();
    }

    public static void main(String[] args) throws Exception {
        VoldemortConfig config = null;
        try {
            if (args.length == 0) {
                config = VoldemortConfig.loadFromEnvironmentVariable();
            } else if (args.length == 1) {
                config = VoldemortConfig.loadFromVoldemortHome(args[0]);
            } else if (args.length == 2) {
                config = VoldemortConfig.loadFromVoldemortHome(args[0], args[1]);
            } else {
                Utils.croak("USAGE: java " + VoldemortServer.class.getName() + " [voldemort_home_dir] [voldemort_config_dir]");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            Utils.croak("Error while loading configuration: " + e.getMessage());
        }
        final VoldemortServer server = new VoldemortServer(config);
        if (!server.isStarted()) {
            server.start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (server.isStarted()) {
                    server.stop();
                }
            }
        });
    }

    public Node getIdentityNode() {
        return this.identityNode;
    }

    public List<VoldemortService> getServices() {
        return this.services;
    }

    public VoldemortService getService(ServiceType type) {
        for (VoldemortService service : this.services) {
            if (!service.getType().equals((Object)type)) continue;
            return service;
        }
        throw new IllegalStateException(type.getDisplayName() + " has not been initialized.");
    }

    public VoldemortConfig getVoldemortConfig() {
        return this.voldemortConfig;
    }

    public StoreRepository getStoreRepository() {
        return this.storeRepository;
    }

    public MetadataStore getMetadataStore() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxOperation(description="force restore data from replication")
    public void restoreDataFromReplication(int numberOfParallelTransfers) {
        AdminClient adminClient = RebalanceUtils.createTempAdminClient(this.voldemortConfig, this.metadata.getCluster(), numberOfParallelTransfers * 2);
        try {
            adminClient.restoreDataFromReplications(this.metadata.getNodeId(), numberOfParallelTransfers);
            Object var4_3 = null;
            adminClient.stop();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            adminClient.stop();
            throw throwable;
        }
    }
}

