/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.protocol.admin;

import com.google.protobuf.Message;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.protocol.VoldemortFilter;
import voldemort.client.protocol.admin.filter.DefaultVoldemortFilter;
import voldemort.client.protocol.pb.ProtoUtils;
import voldemort.client.protocol.pb.VAdminProto;
import voldemort.cluster.Cluster;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortConfig;
import voldemort.server.protocol.StreamRequestHandler;
import voldemort.server.protocol.admin.AdminServiceRequestHandler;
import voldemort.store.ErrorCodeMapper;
import voldemort.store.StorageEngine;
import voldemort.store.StoreDefinition;
import voldemort.store.metadata.MetadataStore;
import voldemort.store.stats.StreamStats;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.EventThrottler;
import voldemort.utils.NetworkClassLoader;
import voldemort.xml.ClusterMapper;

public abstract class FetchStreamRequestHandler
implements StreamRequestHandler {
    protected final VAdminProto.FetchPartitionEntriesRequest request;
    protected final ErrorCodeMapper errorCodeMapper;
    protected final Cluster initialCluster;
    protected final EventThrottler throttler;
    protected final HashMap<Integer, List<Integer>> replicaToPartitionList;
    protected final VoldemortFilter filter;
    protected final StorageEngine<ByteArray, byte[], byte[]> storageEngine;
    protected final ClosableIterator<ByteArray> keyIterator;
    protected long counter;
    protected long skipRecords;
    protected int fetched;
    protected final long startTime;
    protected final StreamStats.Handle handle;
    protected final StreamStats stats;
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected int nodeId;
    protected StoreDefinition storeDef;

    protected FetchStreamRequestHandler(VAdminProto.FetchPartitionEntriesRequest request, MetadataStore metadataStore, ErrorCodeMapper errorCodeMapper, VoldemortConfig voldemortConfig, StoreRepository storeRepository, NetworkClassLoader networkClassLoader, StreamStats stats, StreamStats.Operation operation) {
        this.nodeId = metadataStore.getNodeId();
        this.request = request;
        this.errorCodeMapper = errorCodeMapper;
        this.replicaToPartitionList = ProtoUtils.decodePartitionTuple(request.getReplicaToPartitionList());
        this.stats = stats;
        this.handle = stats.makeHandle(operation, this.replicaToPartitionList);
        this.storageEngine = AdminServiceRequestHandler.getStorageEngine(storeRepository, request.getStore());
        this.storeDef = metadataStore.getStoreDef(request.getStore());
        this.initialCluster = request.hasInitialCluster() ? new ClusterMapper().readCluster(new StringReader(request.getInitialCluster())) : metadataStore.getCluster();
        this.throttler = new EventThrottler(voldemortConfig.getStreamMaxReadBytesPerSec());
        this.filter = request.hasFilter() ? AdminServiceRequestHandler.getFilterFromRequest(request.getFilter(), voldemortConfig, networkClassLoader) : new DefaultVoldemortFilter();
        this.keyIterator = this.storageEngine.keys();
        this.startTime = System.currentTimeMillis();
        this.counter = 0L;
        this.skipRecords = 1L;
        if (request.hasSkipRecords() && request.getSkipRecords() >= 0L) {
            this.skipRecords = request.getSkipRecords() + 1L;
        }
    }

    public final StreamRequestHandler.StreamRequestDirection getDirection() {
        return StreamRequestHandler.StreamRequestDirection.WRITING;
    }

    public final void close(DataOutputStream outputStream) throws IOException {
        this.logger.info((Object)("Successfully scanned " + this.counter + " tuples, fetched " + this.fetched + " tuples for store '" + this.storageEngine.getName() + "' in " + (System.currentTimeMillis() - this.startTime) / 1000L + " s"));
        if (null != this.keyIterator) {
            this.keyIterator.close();
        }
        ProtoUtils.writeEndOfStream(outputStream);
    }

    public final void handleError(DataOutputStream outputStream, VoldemortException e) throws IOException {
        VAdminProto.FetchPartitionEntriesResponse response = VAdminProto.FetchPartitionEntriesResponse.newBuilder().setError(ProtoUtils.encodeError(this.errorCodeMapper, e)).build();
        ProtoUtils.writeMessage(outputStream, (Message)response);
        this.logger.error((Object)("handleFetchPartitionEntries failed for request(" + this.request.toString() + ")"), (Throwable)e);
    }
}

