/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.IdentityHashSet;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.pen.util.ExampleTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricEvaluation {
    public static float getRealness(Operator op, Map<Operator, DataBag> exampleData, boolean overallRealness) {
        int noTuples = 0;
        int noSynthetic = 0;
        for (Map.Entry<Operator, DataBag> e : exampleData.entrySet()) {
            if (((LogicalRelationalOperator)e.getKey()).getAlias() == null) continue;
            DataBag bag = overallRealness ? exampleData.get(e.getKey()) : exampleData.get(op);
            noTuples = (int)((long)noTuples + bag.size());
            Iterator<Tuple> it = bag.iterator();
            while (it.hasNext()) {
                if (!((ExampleTuple)it.next()).synthetic) continue;
                ++noSynthetic;
            }
            if (overallRealness) continue;
            break;
        }
        if (noTuples == 0) {
            if (noSynthetic == 0) {
                return 0.0f;
            }
            return 100.0f;
        }
        return 100.0f * (1.0f - (float)noSynthetic / (float)noTuples);
    }

    public static float getConciseness(Operator op, Map<Operator, DataBag> exampleData, Map<LogicalRelationalOperator, Collection<IdentityHashSet<Tuple>>> OperatorToEqClasses, boolean overallConciseness) {
        DataBag bag = exampleData.get(op);
        int noEqCl = OperatorToEqClasses.get(op).size();
        long noTuples = bag.size();
        float conciseness = 100.0f * ((float)noEqCl / (float)noTuples);
        if (!overallConciseness) {
            return (double)conciseness > 100.0 ? 100.0f : conciseness;
        }
        noEqCl = 0;
        noTuples = 0L;
        conciseness = 0.0f;
        int noOperators = 0;
        for (Map.Entry<LogicalRelationalOperator, Collection<IdentityHashSet<Tuple>>> e : OperatorToEqClasses.entrySet()) {
            if (e.getKey().getAlias() == null) continue;
            ++noOperators;
            bag = exampleData.get(e.getKey());
            noTuples = bag.size();
            noEqCl = e.getValue().size();
            float concise = 100.0f * ((float)noEqCl / (float)noTuples);
            concise = concise > 100.0f ? 100.0f : concise;
            conciseness += concise;
        }
        return conciseness /= (float)noOperators;
    }

    public static float getCompleteness(Operator op, Map<Operator, DataBag> exampleData, Map<LogicalRelationalOperator, Collection<IdentityHashSet<Tuple>>> OperatorToEqClasses, boolean overallCompleteness) {
        int noClasses = 0;
        int noCoveredClasses = 0;
        int noOperators = 0;
        float completeness = 0.0f;
        if (!overallCompleteness) {
            Collection<IdentityHashSet<Tuple>> eqClasses = OperatorToEqClasses.get(op);
            noCoveredClasses = MetricEvaluation.getCompletenessLogic(eqClasses);
            noClasses = eqClasses.size();
            return 100.0f * (float)noCoveredClasses / (float)noClasses;
        }
        for (Map.Entry<LogicalRelationalOperator, Collection<IdentityHashSet<Tuple>>> e : OperatorToEqClasses.entrySet()) {
            noCoveredClasses = 0;
            noClasses = 0;
            if (e.getKey().getAlias() == null) continue;
            ++noOperators;
            Collection<IdentityHashSet<Tuple>> eqClasses = e.getValue();
            noCoveredClasses = MetricEvaluation.getCompletenessLogic(eqClasses);
            completeness += 100.0f * ((float)noCoveredClasses / (float)(noClasses += eqClasses.size()));
        }
        return completeness /= (float)noOperators;
    }

    private static int getCompletenessLogic(Collection<IdentityHashSet<Tuple>> eqClasses) {
        int nCoveredClasses = 0;
        for (IdentityHashSet<Tuple> eqClass : eqClasses) {
            if (eqClass.isEmpty()) continue;
            ++nCoveredClasses;
        }
        return nCoveredClasses;
    }
}

