/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.trigger;

import azkaban.test.trigger.ThresholdChecker;
import azkaban.trigger.CheckerTypeLoader;
import azkaban.trigger.Condition;
import azkaban.trigger.ConditionChecker;
import azkaban.trigger.builtin.BasicTimeChecker;
import azkaban.utils.JSONUtils;
import azkaban.utils.Props;
import azkaban.utils.Utils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class ConditionTest {
    @Test
    public void conditionTest() {
        HashMap<String, ThresholdChecker> checkers = new HashMap<String, ThresholdChecker>();
        ThresholdChecker fake1 = new ThresholdChecker("thresholdchecker1", 10);
        ThresholdChecker fake2 = new ThresholdChecker("thresholdchecker2", 20);
        ThresholdChecker.setVal((int)15);
        checkers.put(fake1.getId(), fake1);
        checkers.put(fake2.getId(), fake2);
        String expr1 = "( " + fake1.getId() + ".eval()" + " && " + fake2.getId() + ".eval()" + " )" + " || " + "( " + fake1.getId() + ".eval()" + " && " + "!" + fake2.getId() + ".eval()" + " )";
        String expr2 = "( " + fake1.getId() + ".eval()" + " && " + fake2.getId() + ".eval()" + " )" + " || " + "( " + fake1.getId() + ".eval()" + " && " + fake2.getId() + ".eval()" + " )";
        Condition cond = new Condition(checkers, expr1);
        System.out.println("Setting expression " + expr1);
        Assert.assertTrue((boolean)cond.isMet());
        cond.setExpression(expr2);
        System.out.println("Setting expression " + expr2);
        Assert.assertFalse((boolean)cond.isMet());
    }

    @Test
    public void jsonConversionTest() throws Exception {
        CheckerTypeLoader checkerTypeLoader = new CheckerTypeLoader();
        checkerTypeLoader.init(new Props());
        Condition.setCheckerLoader((CheckerTypeLoader)checkerTypeLoader);
        HashMap<String, BasicTimeChecker> checkers = new HashMap<String, BasicTimeChecker>();
        DateTime now = DateTime.now();
        String period = "6s";
        BasicTimeChecker timeChecker = new BasicTimeChecker("BasicTimeChecker_1", now.getMillis(), now.getZone(), true, true, Utils.parsePeriodString((String)period));
        System.out.println("checker id is " + timeChecker.getId());
        checkers.put(timeChecker.getId(), timeChecker);
        String expr = String.valueOf(timeChecker.getId()) + ".eval()";
        Condition cond = new Condition(checkers, expr);
        File temp = File.createTempFile("temptest", "temptest");
        temp.deleteOnExit();
        Object obj = cond.toJson();
        JSONUtils.toJSON((Object)obj, (File)temp);
        Condition cond2 = Condition.fromJson((Object)JSONUtils.parseJSONFromFile((File)temp));
        Map checkers2 = cond2.getCheckers();
        Assert.assertTrue((boolean)cond.getExpression().equals(cond2.getExpression()));
        System.out.println("cond1: " + cond.getExpression());
        System.out.println("cond2: " + cond2.getExpression());
        Assert.assertTrue((checkers2.size() == 1 ? 1 : 0) != 0);
        ConditionChecker checker2 = (ConditionChecker)checkers2.get(timeChecker.getId());
        System.out.println("checker1: " + timeChecker.getId());
        System.out.println("checker2: " + checker2.getId());
        Assert.assertTrue((boolean)timeChecker.getId().equals(checker2.getId()));
    }
}

