/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger;

import azkaban.trigger.ActionTypeLoader;
import azkaban.trigger.CheckerTypeLoader;
import azkaban.trigger.Condition;
import azkaban.trigger.ConditionChecker;
import azkaban.trigger.Trigger;
import azkaban.trigger.TriggerAction;
import azkaban.trigger.TriggerLoader;
import azkaban.trigger.TriggerLoaderException;
import azkaban.trigger.TriggerManagerAdapter;
import azkaban.trigger.TriggerManagerException;
import azkaban.trigger.TriggerStatus;
import azkaban.utils.Props;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.log4j.Logger;

public class TriggerManager
implements TriggerManagerAdapter {
    private static Logger logger = Logger.getLogger(TriggerManager.class);
    private static final long DEFAULT_SCANNER_INTERVAL_MS = 60000L;
    private static Map<Integer, Trigger> triggerIdMap = new HashMap<Integer, Trigger>();
    private CheckerTypeLoader checkerTypeLoader;
    private ActionTypeLoader actionTypeLoader;
    private TriggerLoader triggerLoader;
    private final TriggerScannerThread runnerThread;
    private long lastRunnerThreadCheckTime = -1L;
    private long runnerThreadIdleTime = -1L;
    private LocalTriggerJMX jmxStats = new LocalTriggerJMX();

    public TriggerManager(Props props, TriggerLoader triggerLoader) throws TriggerManagerException {
        this.triggerLoader = triggerLoader;
        long scannerInterval = props.getLong("trigger.scan.interval", 60000L);
        this.runnerThread = new TriggerScannerThread(scannerInterval);
        this.checkerTypeLoader = new CheckerTypeLoader();
        this.actionTypeLoader = new ActionTypeLoader();
        try {
            this.checkerTypeLoader.init(props);
            this.actionTypeLoader.init(props);
        }
        catch (Exception e) {
            throw new TriggerManagerException(e);
        }
        Condition.setCheckerLoader(this.checkerTypeLoader);
        Trigger.setActionTypeLoader(this.actionTypeLoader);
    }

    @Override
    public void start() throws TriggerManagerException {
        try {
            List<Trigger> triggers = this.triggerLoader.loadTriggers();
            for (Trigger t : triggers) {
                this.runnerThread.addTrigger(t);
                triggerIdMap.put(t.getTriggerId(), t);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TriggerManagerException(e);
        }
        this.runnerThread.start();
    }

    protected CheckerTypeLoader getCheckerLoader() {
        return this.checkerTypeLoader;
    }

    protected ActionTypeLoader getActionLoader() {
        return this.actionTypeLoader;
    }

    public synchronized void insertTrigger(Trigger t) throws TriggerManagerException {
        try {
            this.triggerLoader.addTrigger(t);
        }
        catch (TriggerLoaderException e) {
            throw new TriggerManagerException(e);
        }
        this.runnerThread.addTrigger(t);
        triggerIdMap.put(t.getTriggerId(), t);
    }

    public synchronized void removeTrigger(int id) throws TriggerManagerException {
        Trigger t = triggerIdMap.get(id);
        if (t != null) {
            this.removeTrigger(triggerIdMap.get(id));
        }
    }

    public synchronized void updateTrigger(int id) throws TriggerManagerException {
        Trigger t;
        if (!triggerIdMap.containsKey(id)) {
            throw new TriggerManagerException("The trigger to update " + id + " doesn't exist!");
        }
        try {
            t = this.triggerLoader.loadTrigger(id);
        }
        catch (TriggerLoaderException e) {
            throw new TriggerManagerException(e);
        }
        this.updateTrigger(t);
    }

    public synchronized void updateTrigger(Trigger t) throws TriggerManagerException {
        this.runnerThread.deleteTrigger(triggerIdMap.get(t.getTriggerId()));
        this.runnerThread.addTrigger(t);
        triggerIdMap.put(t.getTriggerId(), t);
    }

    public synchronized void removeTrigger(Trigger t) throws TriggerManagerException {
        this.runnerThread.deleteTrigger(t);
        triggerIdMap.remove(t.getTriggerId());
        try {
            t.stopCheckers();
            this.triggerLoader.removeTrigger(t);
        }
        catch (TriggerLoaderException e) {
            throw new TriggerManagerException(e);
        }
    }

    public List<Trigger> getTriggers() {
        return new ArrayList<Trigger>(triggerIdMap.values());
    }

    public Map<String, Class<? extends ConditionChecker>> getSupportedCheckers() {
        return this.checkerTypeLoader.getSupportedCheckers();
    }

    public synchronized Trigger getTrigger(int triggerId) {
        return triggerIdMap.get(triggerId);
    }

    public void expireTrigger(int triggerId) {
        Trigger t = this.getTrigger(triggerId);
        t.setStatus(TriggerStatus.EXPIRED);
    }

    public List<Trigger> getTriggers(String triggerSource) {
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        for (Trigger t : triggerIdMap.values()) {
            if (!t.getSource().equals(triggerSource)) continue;
            triggers.add(t);
        }
        return triggers;
    }

    @Override
    public List<Trigger> getTriggerUpdates(String triggerSource, long lastUpdateTime) throws TriggerManagerException {
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        for (Trigger t : triggerIdMap.values()) {
            if (!t.getSource().equals(triggerSource) || t.getLastModifyTime() <= lastUpdateTime) continue;
            triggers.add(t);
        }
        return triggers;
    }

    @Override
    public List<Integer> getTriggerUpdates(long lastUpdateTime) throws TriggerManagerException {
        ArrayList<Integer> triggers = new ArrayList<Integer>();
        for (Trigger t : triggerIdMap.values()) {
            if (t.getLastModifyTime() <= lastUpdateTime) continue;
            triggers.add(t.getTriggerId());
        }
        return triggers;
    }

    public void loadTrigger(int triggerId) throws TriggerManagerException {
        Trigger t;
        try {
            t = this.triggerLoader.loadTrigger(triggerId);
        }
        catch (TriggerLoaderException e) {
            throw new TriggerManagerException(e);
        }
        if (t.getStatus().equals((Object)TriggerStatus.PREPARING)) {
            triggerIdMap.put(t.getTriggerId(), t);
            this.runnerThread.addTrigger(t);
            t.setStatus(TriggerStatus.READY);
        }
    }

    @Override
    public void insertTrigger(Trigger t, String user) throws TriggerManagerException {
        this.insertTrigger(t);
    }

    @Override
    public void removeTrigger(int id, String user) throws TriggerManagerException {
        this.removeTrigger(id);
    }

    @Override
    public void updateTrigger(int triggerId, String user) throws TriggerManagerException {
        this.updateTrigger(triggerId);
    }

    @Override
    public void updateTrigger(Trigger t, String user) throws TriggerManagerException {
        this.updateTrigger(t);
    }

    @Override
    public void insertTrigger(int triggerId, String user) throws TriggerManagerException {
        Trigger t;
        try {
            t = this.triggerLoader.loadTrigger(triggerId);
        }
        catch (TriggerLoaderException e) {
            throw new TriggerManagerException(e);
        }
        if (t != null) {
            this.insertTrigger(t);
        }
    }

    @Override
    public void shutdown() {
        this.runnerThread.shutdown();
    }

    @Override
    public TriggerManagerAdapter.TriggerJMX getJMX() {
        return this.jmxStats;
    }

    @Override
    public void registerCheckerType(String name, Class<? extends ConditionChecker> checker) {
        this.checkerTypeLoader.registerCheckerType(name, checker);
    }

    @Override
    public void registerActionType(String name, Class<? extends TriggerAction> action) {
        this.actionTypeLoader.registerActionType(name, action);
    }

    private class LocalTriggerJMX
    implements TriggerManagerAdapter.TriggerJMX {
        private LocalTriggerJMX() {
        }

        @Override
        public long getLastRunnerThreadCheckTime() {
            return TriggerManager.this.lastRunnerThreadCheckTime;
        }

        @Override
        public boolean isRunnerThreadActive() {
            return TriggerManager.this.runnerThread.isAlive();
        }

        @Override
        public String getPrimaryServerHost() {
            return "local";
        }

        @Override
        public int getNumTriggers() {
            return triggerIdMap.size();
        }

        @Override
        public String getTriggerSources() {
            HashSet<String> sources = new HashSet<String>();
            for (Trigger t : triggerIdMap.values()) {
                sources.add(t.getSource());
            }
            return ((Object)sources).toString();
        }

        @Override
        public String getTriggerIds() {
            return triggerIdMap.keySet().toString();
        }

        @Override
        public long getScannerIdleTime() {
            return TriggerManager.this.runnerThreadIdleTime;
        }

        @Override
        public Map<String, Object> getAllJMXMbeans() {
            return new HashMap<String, Object>();
        }
    }

    private class TriggerScannerThread
    extends Thread {
        private BlockingQueue<Trigger> triggers = new PriorityBlockingQueue<Trigger>(1, new TriggerComparator());
        private boolean shutdown = false;
        private final long scannerInterval;

        public TriggerScannerThread(long scannerInterval) {
            this.setName("TriggerRunnerManager-Trigger-Scanner-Thread");
            this.scannerInterval = scannerInterval;
        }

        public void shutdown() {
            logger.error((Object)("Shutting down trigger manager thread " + this.getName()));
            this.shutdown = true;
            this.interrupt();
        }

        public synchronized void addTrigger(Trigger t) {
            t.updateNextCheckTime();
            this.triggers.add(t);
        }

        public synchronized void deleteTrigger(Trigger t) {
            this.triggers.remove(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.shutdown) {
                TriggerScannerThread triggerScannerThread = this;
                synchronized (triggerScannerThread) {
                    try {
                        TriggerManager.this.lastRunnerThreadCheckTime = System.currentTimeMillis();
                        try {
                            this.checkAllTriggers();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error((Object)e.getMessage());
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            logger.error((Object)t.getMessage());
                        }
                        TriggerManager.this.runnerThreadIdleTime = this.scannerInterval - (System.currentTimeMillis() - TriggerManager.this.lastRunnerThreadCheckTime);
                        if (TriggerManager.this.runnerThreadIdleTime < 0L) {
                            logger.error((Object)("Trigger manager thread " + this.getName() + " is too busy!"));
                        } else {
                            this.wait(TriggerManager.this.runnerThreadIdleTime);
                        }
                    }
                    catch (InterruptedException e) {
                        logger.info((Object)"Interrupted. Probably to shut down.");
                    }
                }
            }
        }

        private void checkAllTriggers() throws TriggerManagerException {
            long now = System.currentTimeMillis();
            for (Trigger t : this.triggers) {
                if (t.getNextCheckTime() > now) {
                    logger.info((Object)("Skipping trigger" + t.getTriggerId() + " until " + t.getNextCheckTime()));
                    continue;
                }
                logger.info((Object)("Checking trigger " + t.getTriggerId()));
                if (t.getStatus().equals((Object)TriggerStatus.READY)) {
                    if (t.triggerConditionMet()) {
                        this.onTriggerTrigger(t);
                    } else if (t.expireConditionMet()) {
                        this.onTriggerExpire(t);
                    }
                }
                if (t.getStatus().equals((Object)TriggerStatus.EXPIRED) && t.getSource().equals("azkaban")) {
                    TriggerManager.this.removeTrigger(t);
                    continue;
                }
                t.updateNextCheckTime();
            }
        }

        private void onTriggerTrigger(Trigger t) throws TriggerManagerException {
            List<TriggerAction> actions = t.getTriggerActions();
            for (TriggerAction action : actions) {
                try {
                    logger.info((Object)"Doing trigger actions");
                    action.doAction();
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to do action " + action.getDescription()), (Throwable)e);
                }
                catch (Throwable th) {
                    logger.error((Object)("Failed to do action " + action.getDescription()), th);
                }
            }
            if (t.isResetOnTrigger()) {
                t.resetTriggerConditions();
                t.resetExpireCondition();
            } else {
                t.setStatus(TriggerStatus.EXPIRED);
            }
            try {
                TriggerManager.this.triggerLoader.updateTrigger(t);
            }
            catch (TriggerLoaderException e) {
                throw new TriggerManagerException(e);
            }
        }

        private void onTriggerExpire(Trigger t) throws TriggerManagerException {
            List<TriggerAction> expireActions = t.getExpireActions();
            for (TriggerAction action : expireActions) {
                try {
                    logger.info((Object)"Doing expire actions");
                    action.doAction();
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to do expire action " + action.getDescription()), (Throwable)e);
                }
                catch (Throwable th) {
                    logger.error((Object)("Failed to do expire action " + action.getDescription()), th);
                }
            }
            if (t.isResetOnExpire()) {
                t.resetTriggerConditions();
                t.resetExpireCondition();
            } else {
                t.setStatus(TriggerStatus.EXPIRED);
            }
            try {
                TriggerManager.this.triggerLoader.updateTrigger(t);
            }
            catch (TriggerLoaderException e) {
                throw new TriggerManagerException(e);
            }
        }

        private class TriggerComparator
        implements Comparator<Trigger> {
            private TriggerComparator() {
            }

            @Override
            public int compare(Trigger arg0, Trigger arg1) {
                long second;
                long first = arg1.getNextCheckTime();
                if (first == (second = arg0.getNextCheckTime())) {
                    return 0;
                }
                if (first < second) {
                    return 1;
                }
                return -1;
            }
        }
    }
}

