/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.joda.time.Days;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.Years;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    public static final Random RANDOM = new Random();

    private Utils() {
    }

    public static boolean equals(Object a, Object b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.equals(b);
    }

    public static <T> T nonNull(T t) {
        if (t == null) {
            throw new IllegalArgumentException("Null value not allowed.");
        }
        return t;
    }

    public static File findFilefromDir(File dir, String fn) {
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().equals(fn)) {
                    return f;
                }
                ++n2;
            }
        }
        return null;
    }

    public static void croak(String message, int exitCode) {
        System.err.println(message);
        System.exit(exitCode);
    }

    public static File createTempDir() {
        return Utils.createTempDir((File)new File(System.getProperty("java.io.tmpdir")));
    }

    public static File createTempDir(File parent) {
        File temp = new File(parent, Integer.toString(Math.abs(RANDOM.nextInt()) % 100000000));
        temp.delete();
        temp.mkdir();
        temp.deleteOnExit();
        return temp;
    }

    public static void zip(File input, File output) throws IOException {
        FileOutputStream out = new FileOutputStream(output);
        ZipOutputStream zOut = new ZipOutputStream(out);
        try {
            Utils.zipFile((String)"", (File)input, (ZipOutputStream)zOut);
        }
        finally {
            zOut.close();
        }
    }

    public static void zipFolderContent(File folder, File output) throws IOException {
        FileOutputStream out = new FileOutputStream(output);
        ZipOutputStream zOut = new ZipOutputStream(out);
        try {
            File[] files = folder.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    Utils.zipFile((String)"", (File)f, (ZipOutputStream)zOut);
                    ++n2;
                }
            }
        }
        finally {
            zOut.close();
        }
    }

    private static void zipFile(String path, File input, ZipOutputStream zOut) throws IOException {
        block5: {
            block4: {
                if (!input.isDirectory()) break block4;
                File[] files = input.listFiles();
                if (files == null) break block5;
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    String childPath = String.valueOf(path) + input.getName() + (f.isDirectory() ? "/" : "");
                    Utils.zipFile((String)childPath, (File)f, (ZipOutputStream)zOut);
                    ++n2;
                }
                break block5;
            }
            String childPath = String.valueOf(path) + (path.length() > 0 ? "/" : "") + input.getName();
            ZipEntry entry = new ZipEntry(childPath);
            zOut.putNextEntry(entry);
            BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(input));
            try {
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)zOut);
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    public static void unzip(ZipFile source, File dest) throws IOException {
        Enumeration<? extends ZipEntry> entries = source.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File newFile = new File(dest, entry.getName());
            if (entry.isDirectory()) {
                newFile.mkdirs();
                continue;
            }
            newFile.getParentFile().mkdirs();
            InputStream src = source.getInputStream(entry);
            try {
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(newFile));
                try {
                    IOUtils.copy((InputStream)src, (OutputStream)output);
                }
                finally {
                    ((OutputStream)output).close();
                }
            }
            finally {
                src.close();
            }
        }
    }

    public static String flattenToString(Collection<?> collection, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        for (Object obj : collection) {
            buffer.append(obj.toString());
            buffer.append(',');
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public static Double convertToDouble(Object obj) {
        if (obj instanceof String) {
            return Double.parseDouble((String)obj);
        }
        return (Double)obj;
    }

    private static RuntimeException getCause(InvocationTargetException e) {
        Throwable cause = e.getCause();
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new IllegalStateException(e.getCause());
    }

    public static Class<?>[] getTypes(Object ... args) {
        Class[] argTypes = new Class[args.length];
        int i = 0;
        while (i < argTypes.length) {
            argTypes[i] = args[i].getClass();
            ++i;
        }
        return argTypes;
    }

    public static Object callConstructor(Class<?> c, Object ... args) {
        return Utils.callConstructor(c, (Class[])Utils.getTypes((Object[])args), (Object[])args);
    }

    public static Object callConstructor(Class<?> c, Class<?>[] argTypes, Object[] args) {
        try {
            Constructor<?> cons = c.getConstructor(argTypes);
            return cons.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw Utils.getCause((InvocationTargetException)e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String formatDuration(long startTime, long endTime) {
        if (startTime == -1L) {
            return "-";
        }
        long durationMS = endTime == -1L ? System.currentTimeMillis() - startTime : endTime - startTime;
        long seconds = durationMS / 1000L;
        if (seconds < 60L) {
            return String.valueOf(seconds) + " sec";
        }
        long minutes = seconds / 60L;
        seconds %= 60L;
        if (minutes < 60L) {
            return String.valueOf(minutes) + "m " + seconds + "s";
        }
        long hours = minutes / 60L;
        minutes %= 60L;
        if (hours < 24L) {
            return String.valueOf(hours) + "h " + minutes + "m " + seconds + "s";
        }
        long days = hours / 24L;
        return String.valueOf(days) + "d " + (hours %= 24L) + "h " + minutes + "m";
    }

    public static Object invokeStaticMethod(ClassLoader loader, String className, String methodName, Object ... args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = loader.loadClass(className);
        Class[] argTypes = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            argTypes[i] = args[i].getClass();
            ++i;
        }
        Method method = clazz.getDeclaredMethod(methodName, argTypes);
        return method.invoke(null, args);
    }

    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
    }

    public static ReadablePeriod parsePeriodString(String periodStr) {
        Years period;
        char periodUnit = periodStr.charAt(periodStr.length() - 1);
        if (periodStr.equals("null") || periodUnit == 'n') {
            return null;
        }
        int periodInt = Integer.parseInt(periodStr.substring(0, periodStr.length() - 1));
        switch (periodUnit) {
            case 'y': {
                period = Years.years((int)periodInt);
                break;
            }
            case 'M': {
                period = Months.months((int)periodInt);
                break;
            }
            case 'w': {
                period = Weeks.weeks((int)periodInt);
                break;
            }
            case 'd': {
                period = Days.days((int)periodInt);
                break;
            }
            case 'h': {
                period = Hours.hours((int)periodInt);
                break;
            }
            case 'm': {
                period = Minutes.minutes((int)periodInt);
                break;
            }
            case 's': {
                period = Seconds.seconds((int)periodInt);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid schedule period unit '" + periodUnit);
            }
        }
        return period;
    }

    public static String createPeriodString(ReadablePeriod period) {
        String periodStr = "null";
        if (period == null) {
            return "null";
        }
        if (period.get(DurationFieldType.years()) > 0) {
            int years = period.get(DurationFieldType.years());
            periodStr = String.valueOf(years) + "y";
        } else if (period.get(DurationFieldType.months()) > 0) {
            int months = period.get(DurationFieldType.months());
            periodStr = String.valueOf(months) + "M";
        } else if (period.get(DurationFieldType.weeks()) > 0) {
            int weeks = period.get(DurationFieldType.weeks());
            periodStr = String.valueOf(weeks) + "w";
        } else if (period.get(DurationFieldType.days()) > 0) {
            int days = period.get(DurationFieldType.days());
            periodStr = String.valueOf(days) + "d";
        } else if (period.get(DurationFieldType.hours()) > 0) {
            int hours = period.get(DurationFieldType.hours());
            periodStr = String.valueOf(hours) + "h";
        } else if (period.get(DurationFieldType.minutes()) > 0) {
            int minutes = period.get(DurationFieldType.minutes());
            periodStr = String.valueOf(minutes) + "m";
        } else if (period.get(DurationFieldType.seconds()) > 0) {
            int seconds = period.get(DurationFieldType.seconds());
            periodStr = String.valueOf(seconds) + "s";
        }
        return periodStr;
    }
}

