/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;

public abstract class Transport
extends Service {
    private volatile Vector transportListeners = null;

    public Transport(Session session, URLName urlname) {
        super(session, urlname);
    }

    public static void send(Message msg) throws MessagingException {
        msg.saveChanges();
        Transport.send0(msg, msg.getAllRecipients());
    }

    public static void send(Message msg, Address[] addresses) throws MessagingException {
        msg.saveChanges();
        Transport.send0(msg, addresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void send0(Message msg, Address[] addresses) throws MessagingException {
        Session s;
        if (addresses == null) throw new SendFailedException("No recipient addresses");
        if (addresses.length == 0) {
            throw new SendFailedException("No recipient addresses");
        }
        Hashtable protocols = new Hashtable();
        Vector<Object> invalid = new Vector<Object>();
        Vector<Address> validSent = new Vector<Address>();
        Vector<Address> validUnsent = new Vector<Address>();
        for (int i = 0; i < addresses.length; ++i) {
            if (protocols.containsKey(addresses[i].getType())) {
                Vector v = (Vector)protocols.get(addresses[i].getType());
                v.addElement(addresses[i]);
                continue;
            }
            Vector<Address> w = new Vector<Address>();
            w.addElement(addresses[i]);
            protocols.put(addresses[i].getType(), w);
        }
        int dsize = protocols.size();
        if (dsize == 0) {
            throw new SendFailedException("No recipient addresses");
        }
        Session session = s = msg.session != null ? msg.session : Session.getDefaultInstance(System.getProperties(), null);
        if (dsize == 1) {
            Transport transport = s.getTransport(addresses[0]);
            try {
                transport.connect();
                transport.sendMessage(msg, addresses);
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                transport.close();
                throw throwable;
            }
            transport.close();
            return;
        }
        MessagingException chainedEx = null;
        boolean sendFailed = false;
        Enumeration e = protocols.elements();
        while (e.hasMoreElements()) {
            Object var19_26;
            Vector v = (Vector)e.nextElement();
            Object[] protaddresses = new Address[v.size()];
            v.copyInto(protaddresses);
            Transport transport = s.getTransport((Address)protaddresses[0]);
            if (transport == null) {
                for (int j = 0; j < protaddresses.length; ++j) {
                    invalid.addElement(protaddresses[j]);
                }
                continue;
            }
            try {
                try {
                    transport.connect();
                    transport.sendMessage(msg, (Address[])protaddresses);
                }
                catch (SendFailedException sex) {
                    Address[] c;
                    sendFailed = true;
                    if (chainedEx == null) {
                        chainedEx = sex;
                    } else {
                        chainedEx.setNextException(sex);
                    }
                    Address[] a = sex.getInvalidAddresses();
                    if (a != null) {
                        for (int j = 0; j < a.length; ++j) {
                            invalid.addElement(a[j]);
                        }
                    }
                    if ((a = sex.getValidSentAddresses()) != null) {
                        for (int k = 0; k < a.length; ++k) {
                            validSent.addElement(a[k]);
                        }
                    }
                    if ((c = sex.getValidUnsentAddresses()) != null) {
                        for (int l = 0; l < c.length; ++l) {
                            validUnsent.addElement(c[l]);
                        }
                    }
                    var19_26 = null;
                    transport.close();
                    continue;
                }
                catch (MessagingException mex) {
                    sendFailed = true;
                    if (chainedEx == null) {
                        chainedEx = mex;
                    } else {
                        chainedEx.setNextException(mex);
                    }
                    var19_26 = null;
                    transport.close();
                    continue;
                }
                var19_26 = null;
            }
            catch (Throwable throwable) {
                var19_26 = null;
                transport.close();
                throw throwable;
            }
            transport.close();
        }
        if (!sendFailed && invalid.size() == 0) {
            if (validUnsent.size() == 0) return;
        }
        Object[] a = null;
        Object[] b = null;
        Object[] c = null;
        if (validSent.size() > 0) {
            a = new Address[validSent.size()];
            validSent.copyInto(a);
        }
        if (validUnsent.size() > 0) {
            b = new Address[validUnsent.size()];
            validUnsent.copyInto(b);
        }
        if (invalid.size() <= 0) throw new SendFailedException("Sending failed", chainedEx, (Address[])a, (Address[])b, (Address[])c);
        c = new Address[invalid.size()];
        invalid.copyInto(c);
        throw new SendFailedException("Sending failed", chainedEx, (Address[])a, (Address[])b, (Address[])c);
    }

    public abstract void sendMessage(Message var1, Address[] var2) throws MessagingException;

    public synchronized void addTransportListener(TransportListener l) {
        if (this.transportListeners == null) {
            this.transportListeners = new Vector();
        }
        this.transportListeners.addElement(l);
    }

    public synchronized void removeTransportListener(TransportListener l) {
        if (this.transportListeners != null) {
            this.transportListeners.removeElement(l);
        }
    }

    protected void notifyTransportListeners(int type, Address[] validSent, Address[] validUnsent, Address[] invalid, Message msg) {
        if (this.transportListeners == null) {
            return;
        }
        TransportEvent e = new TransportEvent(this, type, validSent, validUnsent, invalid, msg);
        this.queueEvent(e, this.transportListeners);
    }
}

