/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.PigCounters;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DefaultAbstractBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalCachedBag
extends DefaultAbstractBag {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(InternalCachedBag.class);
    private transient int cacheLimit;
    private transient long maxMemUsage;
    private transient long memUsage;
    private transient DataOutputStream out;
    private transient boolean addDone;
    private transient TupleFactory factory;
    private transient int numTuplesSpilled = 0;

    public InternalCachedBag() {
        this(1);
    }

    public InternalCachedBag(int bagCount) {
        String usage;
        float percent = 0.2f;
        if (PigMapReduce.sJobConfInternal.get() != null && (usage = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.cachedbag.memusage")) != null) {
            percent = Float.parseFloat(usage);
        }
        this.init(bagCount, percent);
    }

    public InternalCachedBag(int bagCount, float percent) {
        this.init(bagCount, percent);
    }

    private void init(int bagCount, float percent) {
        this.factory = TupleFactory.getInstance();
        this.mContents = new ArrayList();
        long max = Runtime.getRuntime().maxMemory();
        this.maxMemUsage = (long)((float)max * percent / (float)bagCount);
        this.cacheLimit = Integer.MAX_VALUE;
        if (this.maxMemUsage < 1L) {
            this.cacheLimit = 0;
        }
        this.addDone = false;
    }

    @Override
    public void add(Tuple t) {
        if (this.addDone) {
            throw new IllegalStateException("InternalCachedBag is closed for adding new tuples");
        }
        if (this.mContents.size() < this.cacheLimit) {
            this.mContents.add(t);
            if (this.mContents.size() < 100) {
                this.memUsage += t.getMemorySize();
                long avgUsage = this.memUsage / (long)this.mContents.size();
                if (avgUsage > 0L) {
                    this.cacheLimit = (int)(this.maxMemUsage / avgUsage);
                }
            }
        } else {
            try {
                if (this.out == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Memory can hold " + this.mContents.size() + " records, put the rest in spill file."));
                    }
                    this.out = this.getSpillFile();
                    this.incSpillCount(PigCounters.PROACTIVE_SPILL_COUNT_BAGS);
                }
                t.write(this.out);
                ++this.numTuplesSpilled;
                if (this.numTuplesSpilled > 1000) {
                    this.updateSpillRecCounter();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ++this.mSize;
    }

    private void updateSpillRecCounter() {
        this.incSpillCount(PigCounters.PROACTIVE_SPILL_COUNT_RECS, this.numTuplesSpilled);
        this.numTuplesSpilled = 0;
    }

    @Override
    public void addAll(DataBag b) {
        Iterator<Tuple> iter = b.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
    }

    @Override
    public void addAll(Collection<Tuple> c) {
        Iterator<Tuple> iter = c.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
    }

    private void addDone() {
        if (this.out != null) {
            try {
                this.out.flush();
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.numTuplesSpilled > 0) {
            this.updateSpillRecCounter();
        }
        this.addDone = true;
    }

    @Override
    public void clear() {
        if (!this.addDone) {
            this.addDone();
        }
        super.clear();
        this.addDone = false;
        this.out = null;
    }

    @Override
    public boolean isDistinct() {
        return false;
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public Iterator<Tuple> iterator() {
        if (!this.addDone) {
            this.addDone();
        }
        return new CachedBagIterator();
    }

    @Override
    public long spill() {
        throw new RuntimeException("InternalCachedBag.spill() should not be called");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CachedBagIterator
    implements Iterator<Tuple> {
        Iterator<Tuple> iter;
        DataInputStream in;
        Tuple next;
        long numTuplesRead = 0L;

        public CachedBagIterator() {
            this.iter = InternalCachedBag.this.mContents.iterator();
            if (InternalCachedBag.this.mSpillFiles != null && InternalCachedBag.this.mSpillFiles.size() > 0) {
                File file = (File)InternalCachedBag.this.mSpillFiles.get(0);
                try {
                    this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                }
                catch (FileNotFoundException fnfe) {
                    String msg = "Unable to find our spill file.";
                    throw new RuntimeException(msg, fnfe);
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.iter.hasNext()) {
                this.next = this.iter.next();
                return true;
            }
            if (this.in == null) {
                return false;
            }
            try {
                Tuple t = InternalCachedBag.this.factory.newTuple();
                t.readFields(this.in);
                this.next = t;
                return true;
            }
            catch (EOFException eof) {
                try {
                    this.in.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.in = null;
                return false;
            }
            catch (IOException e) {
                String msg = "Unable to read our spill file.";
                throw new RuntimeException(msg, e);
            }
        }

        @Override
        public Tuple next() {
            if (this.next == null && !this.hasNext()) {
                throw new NoSuchElementException("No more elements from iterator");
            }
            Tuple t = this.next;
            this.next = null;
            ++this.numTuplesRead;
            if ((this.numTuplesRead & 0x3FFFL) == 0L) {
                InternalCachedBag.this.reportProgress();
            }
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported for CachedBagIterator");
        }
    }
}

