/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;

public class DF
extends Shell {
    public static final long DF_INTERVAL_DEFAULT = 3000L;
    private final String dirPath;
    private final File dirFile;
    private String filesystem;
    private String mount;

    public DF(File path, Configuration conf) throws IOException {
        this(path, conf.getLong("dfs.df.interval", 3000L));
    }

    public DF(File path, long dfInterval) throws IOException {
        super(dfInterval);
        this.dirPath = path.getCanonicalPath();
        this.dirFile = path.getCanonicalFile();
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public String getFilesystem() throws IOException {
        this.run();
        return this.filesystem;
    }

    public long getCapacity() {
        return this.dirFile.getTotalSpace();
    }

    public long getUsed() {
        return this.dirFile.getTotalSpace() - this.dirFile.getFreeSpace();
    }

    public long getAvailable() {
        return this.dirFile.getUsableSpace();
    }

    public int getPercentUsed() {
        double cap = this.getCapacity();
        double used = cap - (double)this.getAvailable();
        return (int)(used * 100.0 / cap);
    }

    public String getMount() throws IOException {
        this.run();
        return this.mount;
    }

    public String toString() {
        return "df -k " + this.mount + "\n" + this.filesystem + "\t" + this.getCapacity() / 1024L + "\t" + this.getUsed() / 1024L + "\t" + this.getAvailable() / 1024L + "\t" + this.getPercentUsed() + "%\t" + this.mount;
    }

    @Override
    protected String[] getExecString() {
        return new String[]{"bash", "-c", "exec 'df' '-k' '" + this.dirPath + "' 2>/dev/null"};
    }

    @Override
    protected void parseExecResult(BufferedReader lines) throws IOException {
        lines.readLine();
        String line = lines.readLine();
        if (line == null) {
            throw new IOException("Expecting a line not the end of stream");
        }
        StringTokenizer tokens = new StringTokenizer(line, " \t\n\r\f%");
        this.filesystem = tokens.nextToken();
        if (!tokens.hasMoreTokens()) {
            line = lines.readLine();
            if (line == null) {
                throw new IOException("Expecting a line not the end of stream");
            }
            tokens = new StringTokenizer(line, " \t\n\r\f%");
        }
        Long.parseLong(tokens.nextToken());
        Long.parseLong(tokens.nextToken());
        Long.parseLong(tokens.nextToken());
        Integer.parseInt(tokens.nextToken());
        this.mount = tokens.nextToken();
    }

    public static void main(String[] args) throws Exception {
        String path = ".";
        if (args.length > 0) {
            path = args[0];
        }
        System.out.println(new DF(new File(path), 3000L).toString());
    }
}

